/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnPartitionCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public final class IExecutorDelegatingFuture<V>
extends ClientDelegatingFuture<V> {
    private final ClientContext context;
    private final UUID uuid;
    private final Member member;
    private final int partitionId;
    private final String objectName;

    IExecutorDelegatingFuture(ClientInvocationFuture future, ClientContext context, UUID uuid, V defaultValue, ClientMessageDecoder resultDecoder, String objectName, Member member) {
        super(future, (SerializationService)context.getSerializationService(), resultDecoder, defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.partitionId = -1;
        this.objectName = objectName;
        this.member = member;
    }

    IExecutorDelegatingFuture(ClientInvocationFuture future, ClientContext context, UUID uuid, V defaultValue, ClientMessageDecoder resultDecoder, String objectName, int partitionId) {
        super(future, (SerializationService)context.getSerializationService(), resultDecoder, defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.objectName = objectName;
        this.member = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        boolean cancelSuccessful = false;
        try {
            cancelSuccessful = this.invokeCancelRequest(mayInterruptIfRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        this.completeExceptionally(new CancellationException());
        return cancelSuccessful;
    }

    private boolean invokeCancelRequest(boolean mayInterruptIfRunning) throws InterruptedException, ExecutionException {
        this.waitForRequestToBeSend();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.partitionId > -1) {
            ClientMessage request = ExecutorServiceCancelOnPartitionCodec.encodeRequest(this.uuid, mayInterruptIfRunning);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)this.objectName, this.partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            return ExecutorServiceCancelOnPartitionCodec.decodeResponse((ClientMessage)f.get());
        }
        ClientMessage request = ExecutorServiceCancelOnMemberCodec.encodeRequest(this.uuid, this.member.getUuid(), mayInterruptIfRunning);
        ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)this.objectName, this.member.getUuid());
        ClientInvocationFuture f = clientInvocation.invoke();
        return ExecutorServiceCancelOnMemberCodec.decodeResponse((ClientMessage)f.get());
    }

    private void waitForRequestToBeSend() throws InterruptedException {
        ClientInvocationFuture future = this.getFuture();
        future.getInvocation().waitInvoked();
    }
}

