/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlFetchCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.client.SqlAbstractMessageTask;
import com.hazelcast.sql.impl.client.SqlClientUtils;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlFetchResponse;
import com.hazelcast.sql.impl.client.SqlPage;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class SqlFetchMessageTask
extends SqlAbstractMessageTask<SqlFetchCodec.RequestParameters> {
    public SqlFetchMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        UUID localMemberId = this.nodeEngine.getLocalMember().getUuid();
        SqlInternalService service = this.nodeEngine.getSqlService().getInternalService();
        try {
            SqlPage page = service.getClientStateRegistry().fetch(this.endpoint.getUuid(), ((SqlFetchCodec.RequestParameters)this.parameters).queryId, ((SqlFetchCodec.RequestParameters)this.parameters).cursorBufferSize, this.serializationService);
            return new SqlFetchResponse(page.getRows(), page.isLast(), null);
        }
        catch (Exception e) {
            SqlError error = SqlClientUtils.exceptionToClientError(e, localMemberId);
            return new SqlFetchResponse(null, false, error);
        }
    }

    @Override
    protected SqlFetchCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return SqlFetchCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        SqlFetchResponse response0 = (SqlFetchResponse)response;
        List<List<Data>> rowPage = response0.getRowPage();
        Collection rowPage0 = rowPage;
        return SqlFetchCodec.encodeResponse(rowPage0, response0.isRowPageLast(), response0.getError());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:sqlService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "fetch";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((SqlFetchCodec.RequestParameters)this.parameters).queryId, ((SqlFetchCodec.RequestParameters)this.parameters).cursorBufferSize};
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

