/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.instance.Node;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.impl.CheckReplicaVersionTask;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionReplicaVersions;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.impl.ReplicaSyncInfo;
import com.hazelcast.internal.partition.operation.ReplicaSyncRequest;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.EntryTaskSchedulerFactory;
import com.hazelcast.util.scheduler.ScheduleType;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class PartitionReplicaManager {
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final InternalPartitionServiceImpl partitionService;
    private final PartitionStateManager partitionStateManager;
    private final PartitionReplicaVersions[] replicaVersions;
    private final AtomicReferenceArray<ReplicaSyncInfo> replicaSyncRequests;
    private final EntryTaskScheduler<Integer, ReplicaSyncInfo> replicaSyncScheduler;
    @Probe
    private final Semaphore replicaSyncProcessLock;
    @Probe
    private final MwCounter replicaSyncRequestsCounter = MwCounter.newMwCounter();
    private final long partitionMigrationTimeout;
    private final int partitionCount;
    private final int maxParallelReplications;

    PartitionReplicaManager(Node node, InternalPartitionServiceImpl partitionService) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.logger = node.getLogger(this.getClass());
        this.partitionService = partitionService;
        this.partitionCount = partitionService.getPartitionCount();
        this.partitionStateManager = partitionService.getPartitionStateManager();
        HazelcastProperties properties = node.getProperties();
        this.partitionMigrationTimeout = properties.getMillis(GroupProperty.PARTITION_MIGRATION_TIMEOUT);
        this.maxParallelReplications = properties.getInteger(GroupProperty.PARTITION_MAX_PARALLEL_REPLICATIONS);
        this.replicaSyncProcessLock = new Semaphore(this.maxParallelReplications);
        this.replicaVersions = new PartitionReplicaVersions[this.partitionCount];
        for (int i = 0; i < this.replicaVersions.length; ++i) {
            this.replicaVersions[i] = new PartitionReplicaVersions(i);
        }
        InternalExecutionService executionService = this.nodeEngine.getExecutionService();
        TaskScheduler globalScheduler = executionService.getGlobalTaskScheduler();
        this.replicaSyncScheduler = EntryTaskSchedulerFactory.newScheduler(globalScheduler, new ReplicaSyncEntryProcessor(), ScheduleType.POSTPONE);
        this.replicaSyncRequests = new AtomicReferenceArray(this.partitionCount);
    }

    public void triggerPartitionReplicaSync(int partitionId, int replicaIndex, long delayMillis) {
        if (replicaIndex < 0 || replicaIndex > 7) {
            throw new IllegalArgumentException("Invalid replica index! replicaIndex=" + replicaIndex + " for partitionId=" + partitionId);
        }
        if (!this.checkSyncPartitionTarget(partitionId, replicaIndex)) {
            return;
        }
        InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(partitionId);
        Address target = partition.getOwnerOrNull();
        ReplicaSyncInfo syncInfo = new ReplicaSyncInfo(partitionId, replicaIndex, target);
        if (delayMillis > 0L) {
            this.schedulePartitionReplicaSync(syncInfo, target, delayMillis, "EXPLICIT DELAY");
            return;
        }
        if (!this.partitionService.isReplicaSyncAllowed() || partition.isMigrating()) {
            this.schedulePartitionReplicaSync(syncInfo, target, 500L, "MIGRATION IS DISABLED OR PARTITION IS MIGRATING");
            return;
        }
        if (this.replicaSyncRequests.compareAndSet(partitionId, null, syncInfo)) {
            if (this.fireSyncReplicaRequest(syncInfo, target)) {
                return;
            }
            this.replicaSyncRequests.compareAndSet(partitionId, syncInfo, null);
            this.schedulePartitionReplicaSync(syncInfo, target, 500L, "NO PERMIT AVAILABLE");
            return;
        }
        long scheduleDelay = this.getReplicaSyncScheduleDelay(partitionId);
        this.schedulePartitionReplicaSync(syncInfo, target, scheduleDelay, "ANOTHER SYNC IN PROGRESS");
    }

    boolean checkSyncPartitionTarget(int partitionId, int replicaIndex) {
        InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(partitionId);
        Address target = partition.getOwnerOrNull();
        if (target == null) {
            this.logger.info("Sync replica target is null, no need to sync -> partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
            return false;
        }
        Address thisAddress = this.nodeEngine.getThisAddress();
        if (target.equals(thisAddress)) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("This node is now owner of partition, cannot sync replica -> partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ", partition-info=" + this.partitionStateManager.getPartitionImpl(partitionId));
            }
            return false;
        }
        if (!partition.isOwnerOrBackup(thisAddress)) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("This node is not backup replica of partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + " anymore.");
            }
            return false;
        }
        return true;
    }

    private long getReplicaSyncScheduleDelay(int partitionId) {
        long scheduleDelay = 5000L;
        Address thisAddress = this.node.getThisAddress();
        InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(partitionId);
        ReplicaSyncInfo currentSyncInfo = this.replicaSyncRequests.get(partitionId);
        if (currentSyncInfo != null && !thisAddress.equals(partition.getReplicaAddress(currentSyncInfo.replicaIndex))) {
            this.clearReplicaSyncRequest(partitionId, currentSyncInfo.replicaIndex);
            scheduleDelay = 500L;
        }
        return scheduleDelay;
    }

    private boolean fireSyncReplicaRequest(ReplicaSyncInfo syncInfo, Address target) {
        if (this.node.clusterService.isMemberRemovedWhileClusterIsNotActive(target)) {
            return false;
        }
        if (this.tryToAcquireReplicaSyncPermit()) {
            int partitionId = syncInfo.partitionId;
            int replicaIndex = syncInfo.replicaIndex;
            this.replicaSyncScheduler.cancel(partitionId);
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Sending sync replica request to -> " + target + "; for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
            }
            this.replicaSyncRequestsCounter.inc();
            this.replicaSyncScheduler.schedule(this.partitionMigrationTimeout, partitionId, syncInfo);
            ReplicaSyncRequest syncRequest = new ReplicaSyncRequest(partitionId, replicaIndex);
            this.nodeEngine.getOperationService().send(syncRequest, target);
            return true;
        }
        return false;
    }

    private void schedulePartitionReplicaSync(ReplicaSyncInfo syncInfo, Address target, long delayMillis, String reason) {
        int partitionId = syncInfo.partitionId;
        int replicaIndex = syncInfo.replicaIndex;
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Scheduling [" + delayMillis + "ms] sync replica request to -> " + target + "; for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ". Reason: [" + reason + "]");
        }
        this.replicaSyncScheduler.schedule(delayMillis, partitionId, syncInfo);
    }

    long[] incrementPartitionReplicaVersions(int partitionId, int backupCount) {
        PartitionReplicaVersions replicaVersion = this.replicaVersions[partitionId];
        return replicaVersion.incrementAndGet(backupCount);
    }

    void updatePartitionReplicaVersions(int partitionId, long[] versions, int replicaIndex) {
        PartitionReplicaVersions partitionVersion = this.replicaVersions[partitionId];
        if (!partitionVersion.update(versions, replicaIndex)) {
            this.triggerPartitionReplicaSync(partitionId, replicaIndex, 0L);
        }
    }

    public boolean isPartitionReplicaVersionStale(int partitionId, long[] versions, int replicaIndex) {
        PartitionReplicaVersions partitionVersion = this.replicaVersions[partitionId];
        return partitionVersion.isStale(versions, replicaIndex);
    }

    public boolean isPartitionReplicaVersionDirty(int partitionId) {
        PartitionReplicaVersions partitionVersion = this.replicaVersions[partitionId];
        return partitionVersion.isDirty();
    }

    public long[] getPartitionReplicaVersions(int partitionId) {
        return this.replicaVersions[partitionId].get();
    }

    public void setPartitionReplicaVersions(int partitionId, long[] versions, int replicaOffset) {
        this.replicaVersions[partitionId].set(versions, replicaOffset);
    }

    public void clearPartitionReplicaVersions(int partitionId) {
        this.replicaVersions[partitionId].clear();
    }

    public void finalizeReplicaSync(int partitionId, int replicaIndex, long[] versions) {
        PartitionReplicaVersions replicaVersion = this.replicaVersions[partitionId];
        replicaVersion.clear();
        replicaVersion.set(versions, replicaIndex);
        this.clearReplicaSyncRequest(partitionId, replicaIndex);
    }

    public void clearReplicaSyncRequest(int partitionId, int replicaIndex) {
        ReplicaSyncInfo syncInfo = new ReplicaSyncInfo(partitionId, replicaIndex, null);
        ReplicaSyncInfo currentSyncInfo = this.replicaSyncRequests.get(partitionId);
        this.replicaSyncScheduler.cancelIfExists(partitionId, syncInfo);
        if (syncInfo.equals(currentSyncInfo) && this.replicaSyncRequests.compareAndSet(partitionId, currentSyncInfo, null)) {
            this.releaseReplicaSyncPermit();
        } else if (currentSyncInfo != null && this.logger.isFinestEnabled()) {
            this.logger.finest("Not able to cancel sync! " + syncInfo + " VS Current " + currentSyncInfo);
        }
    }

    void cancelReplicaSyncRequestsTo(Address deadAddress) {
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            ReplicaSyncInfo syncInfo = this.replicaSyncRequests.get(partitionId);
            if (syncInfo == null || !deadAddress.equals(syncInfo.target)) continue;
            this.cancelReplicaSync(partitionId);
        }
    }

    public void cancelReplicaSync(int partitionId) {
        ReplicaSyncInfo syncInfo = this.replicaSyncRequests.get(partitionId);
        if (syncInfo != null && this.replicaSyncRequests.compareAndSet(partitionId, syncInfo, null)) {
            this.replicaSyncScheduler.cancel(partitionId);
            this.releaseReplicaSyncPermit();
        }
    }

    public boolean tryToAcquireReplicaSyncPermit() {
        return this.replicaSyncProcessLock.tryAcquire();
    }

    public void releaseReplicaSyncPermit() {
        this.replicaSyncProcessLock.release();
    }

    List<ReplicaSyncInfo> getOngoingReplicaSyncRequests() {
        int length = this.replicaSyncRequests.length();
        ArrayList<ReplicaSyncInfo> replicaSyncRequestsList = new ArrayList<ReplicaSyncInfo>(length);
        for (int i = 0; i < length; ++i) {
            ReplicaSyncInfo replicaSyncInfo = this.replicaSyncRequests.get(i);
            if (replicaSyncInfo == null) continue;
            replicaSyncRequestsList.add(replicaSyncInfo);
        }
        return replicaSyncRequestsList;
    }

    List<ScheduledEntry<Integer, ReplicaSyncInfo>> getScheduledReplicaSyncRequests() {
        ArrayList<ScheduledEntry<Integer, ReplicaSyncInfo>> entries = new ArrayList<ScheduledEntry<Integer, ReplicaSyncInfo>>();
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            ScheduledEntry<Integer, ReplicaSyncInfo> entry = this.replicaSyncScheduler.get(partitionId);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    void reset() {
        for (int k = 0; k < this.replicaSyncRequests.length(); ++k) {
            this.replicaSyncRequests.set(k, null);
        }
        this.replicaSyncScheduler.cancelAll();
        this.replicaSyncProcessLock.drainPermits();
        this.replicaSyncProcessLock.release(this.maxParallelReplications);
    }

    void scheduleReplicaVersionSync(ExecutionService executionService) {
        long definedBackupSyncCheckInterval = this.node.getProperties().getSeconds(GroupProperty.PARTITION_BACKUP_SYNC_INTERVAL);
        long backupSyncCheckInterval = definedBackupSyncCheckInterval > 0L ? definedBackupSyncCheckInterval : 1L;
        executionService.scheduleWithRepetition(new SyncReplicaVersionTask(), backupSyncCheckInterval, backupSyncCheckInterval, TimeUnit.SECONDS);
    }

    private class SyncReplicaVersionTask
    implements Runnable {
        private SyncReplicaVersionTask() {
        }

        @Override
        public void run() {
            if (!((PartitionReplicaManager)PartitionReplicaManager.this).node.nodeEngine.isRunning() || !PartitionReplicaManager.this.partitionService.isReplicaSyncAllowed()) {
                return;
            }
            for (InternalPartition partition : PartitionReplicaManager.this.partitionStateManager.getPartitions()) {
                if (!partition.isLocal()) continue;
                for (int index = 1; index < 7; ++index) {
                    if (partition.getReplicaAddress(index) == null) continue;
                    CheckReplicaVersionTask task = new CheckReplicaVersionTask(PartitionReplicaManager.this.nodeEngine, PartitionReplicaManager.this.partitionService, partition.getPartitionId(), index, null);
                    PartitionReplicaManager.this.nodeEngine.getOperationService().execute(task);
                }
            }
        }
    }

    private class ReplicaSyncEntryProcessor
    implements ScheduledEntryProcessor<Integer, ReplicaSyncInfo> {
        private ReplicaSyncEntryProcessor() {
        }

        @Override
        public void process(EntryTaskScheduler<Integer, ReplicaSyncInfo> scheduler, Collection<ScheduledEntry<Integer, ReplicaSyncInfo>> entries) {
            for (ScheduledEntry<Integer, ReplicaSyncInfo> entry : entries) {
                InternalPartitionImpl partition;
                int currentReplicaIndex;
                ReplicaSyncInfo syncInfo = entry.getValue();
                int partitionId = syncInfo.partitionId;
                if (PartitionReplicaManager.this.replicaSyncRequests.compareAndSet(partitionId, syncInfo, null)) {
                    PartitionReplicaManager.this.releaseReplicaSyncPermit();
                }
                if ((currentReplicaIndex = (partition = PartitionReplicaManager.this.partitionStateManager.getPartitionImpl(partitionId)).getReplicaIndex(PartitionReplicaManager.this.node.getThisAddress())) <= 0) continue;
                PartitionReplicaManager.this.triggerPartitionReplicaSync(partitionId, currentReplicaIndex, 0L);
            }
        }
    }
}

