/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalSetAddCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalSetRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalSetSizeCodec;
import com.hazelcast.client.proxy.txn.AbstractClientTxnCollectionProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;

public class ClientTxnSetProxy<E>
extends AbstractClientTxnCollectionProxy<E>
implements TransactionalSet<E> {
    public ClientTxnSetProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    @Override
    public boolean add(E e) {
        Preconditions.checkNotNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalSetAddCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), value);
        ClientMessage response = this.invoke(request);
        return TransactionalSetAddCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public boolean remove(E e) {
        Preconditions.checkNotNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalSetRemoveCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), value);
        ClientMessage response = this.invoke(request);
        return TransactionalSetRemoveCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public int size() {
        ClientMessage request = TransactionalSetSizeCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalSetSizeCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:setService";
    }
}

