/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="ISet")
public class SetMBean
extends HazelcastMBean<ISet> {
    private final boolean totalEnabled;
    private final AtomicLong totalAddedItemCount = new AtomicLong();
    private final AtomicLong totalRemovedItemCount = new AtomicLong();
    private final String registrationId;

    protected SetMBean(ISet managedObject, ManagementService service) {
        super(managedObject, service);
        this.totalEnabled = service.instance.node.groupProperties.ENABLE_JMX_DETAILED.getBoolean();
        this.objectName = service.createObjectName("ISet", managedObject.getName());
        if (this.totalEnabled) {
            ItemListener itemListener = new ItemListener(){

                public void itemAdded(ItemEvent item) {
                    SetMBean.this.totalAddedItemCount.incrementAndGet();
                }

                public void itemRemoved(ItemEvent item) {
                    SetMBean.this.totalRemovedItemCount.incrementAndGet();
                }
            };
            this.registrationId = managedObject.addItemListener(itemListener, false);
        } else {
            this.registrationId = null;
        }
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Set")
    public void clear() {
        ((ISet)this.managedObject).clear();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((ISet)this.managedObject).getName();
    }

    @ManagedAnnotation(value="partitionKey")
    @ManagedDescription(value="the partitionKey")
    public String getPartitionKey() {
        return ((ISet)this.managedObject).getPartitionKey();
    }

    @ManagedAnnotation(value="totalAddedItemCount")
    public long getTotalAddedItemCount() {
        return this.totalAddedItemCount.get();
    }

    @ManagedAnnotation(value="totalRemovedItemCount")
    public long getTotalRemovedItemCount() {
        return this.totalRemovedItemCount.get();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.totalEnabled) {
            try {
                ((ISet)this.managedObject).removeItemListener(this.registrationId);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }
}

