/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fernandospr.wns.client;

import ar.com.fernandospr.wns.WnsProxyProperties;
import ar.com.fernandospr.wns.client.WnsResourceBuilder;
import ar.com.fernandospr.wns.exceptions.WnsException;
import ar.com.fernandospr.wns.model.WnsAbstractNotification;
import ar.com.fernandospr.wns.model.WnsNotificationRequestOptional;
import ar.com.fernandospr.wns.model.WnsNotificationResponse;
import ar.com.fernandospr.wns.model.WnsOAuthToken;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.xml.JacksonJaxbXMLProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WnsClient {
    private static final String SCOPE = "notify.windows.com";
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String AUTHENTICATION_URI = "https://login.live.com/accesstoken.srf";
    private String sid;
    private String clientSecret;
    private WnsOAuthToken token;
    private Client client;

    public WnsClient(String sid, String clientSecret, boolean logging) {
        this.sid = sid;
        this.clientSecret = clientSecret;
        this.client = WnsClient.createClient(logging);
    }

    public WnsClient(String sid, String clientSecret, WnsProxyProperties proxyProps, boolean logging) {
        this.sid = sid;
        this.clientSecret = clientSecret;
        this.client = WnsClient.createClient(logging, proxyProps);
    }

    protected String getAuthenticationUri() {
        return AUTHENTICATION_URI;
    }

    private static Client createClient(boolean logging) {
        ClientConfig clientConfig = new ClientConfig(new Class[]{JacksonJaxbXMLProvider.class, JacksonJsonProvider.class});
        Client client = ClientBuilder.newClient((Configuration)clientConfig);
        if (logging) {
            LoggingFilter loggingFilter = new LoggingFilter(Logger.getLogger(WnsClient.class.getName()), true);
            client = (Client)client.register((Object)loggingFilter);
        }
        return client;
    }

    private static Client createClient(boolean logging, WnsProxyProperties proxyProps) {
        ClientConfig clientConfig = new ClientConfig(new Class[]{JacksonJaxbXMLProvider.class, JacksonJsonProvider.class}).connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        WnsClient.setProxyCredentials(clientConfig, proxyProps);
        Client client = ClientBuilder.newClient((Configuration)clientConfig);
        if (logging) {
            LoggingFilter loggingFilter = new LoggingFilter(Logger.getLogger(WnsClient.class.getName()), true);
            client = (Client)client.register((Object)loggingFilter);
        }
        return client;
    }

    private static void setProxyCredentials(ClientConfig clientConfig, WnsProxyProperties proxyProps) {
        if (proxyProps != null) {
            String proxyProtocol = proxyProps.getProtocol();
            String proxyHost = proxyProps.getHost();
            int proxyPort = proxyProps.getPort();
            String proxyUser = proxyProps.getUser();
            String proxyPass = proxyProps.getPass();
            if (proxyHost != null && !proxyHost.trim().isEmpty()) {
                clientConfig.property("jersey.config.client.proxy.uri", (Object)(proxyProtocol + "://" + proxyHost + ":" + proxyPort));
                if (!proxyUser.trim().isEmpty()) {
                    clientConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
                    clientConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
                }
            }
        }
    }

    public void refreshAccessToken() throws WnsException {
        WebTarget target = this.client.target(this.getAuthenticationUri());
        MultivaluedStringMap formData = new MultivaluedStringMap();
        formData.add((Object)"grant_type", (Object)GRANT_TYPE_CLIENT_CREDENTIALS);
        formData.add((Object)"client_id", (Object)this.sid);
        formData.add((Object)"client_secret", (Object)this.clientSecret);
        formData.add((Object)"scope", (Object)SCOPE);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.form((MultivaluedMap)formData));
        if (response.getStatus() != 200) {
            throw new WnsException("Authentication failed. HTTP error code: " + response.getStatus());
        }
        this.token = (WnsOAuthToken)response.readEntity(WnsOAuthToken.class);
    }

    public WnsNotificationResponse push(WnsResourceBuilder resourceBuilder, String channelUri, WnsAbstractNotification notification, int retriesLeft, WnsNotificationRequestOptional optional) throws WnsException {
        WebTarget target = this.client.target(channelUri);
        Invocation.Builder webResourceBuilder = resourceBuilder.build(target, notification, this.getToken().access_token, optional);
        String type = notification.getType().equals("wns/raw") ? "application/octet-stream" : "text/xml";
        Response response = webResourceBuilder.buildPost(Entity.entity((Object)resourceBuilder.getEntityToSendWithNotification(notification), (String)type)).invoke();
        WnsNotificationResponse notificationResponse = new WnsNotificationResponse(channelUri, response.getStatus(), (MultivaluedMap<String, String>)response.getStringHeaders());
        if (notificationResponse.code == 200) {
            return notificationResponse;
        }
        if (notificationResponse.code == 401 && retriesLeft > 0) {
            this.refreshAccessToken();
            return this.push(resourceBuilder, channelUri, notification, --retriesLeft, optional);
        }
        return notificationResponse;
    }

    private WnsOAuthToken getToken() throws WnsException {
        if (this.token == null) {
            this.refreshAccessToken();
        }
        return this.token;
    }

    public List<WnsNotificationResponse> push(WnsResourceBuilder resourceBuilder, List<String> channelUris, WnsAbstractNotification notification, int retriesLeft, WnsNotificationRequestOptional optional) throws WnsException {
        ArrayList<WnsNotificationResponse> responses = new ArrayList<WnsNotificationResponse>();
        for (String channelUri : channelUris) {
            WnsNotificationResponse response = this.push(resourceBuilder, channelUri, notification, retriesLeft, optional);
            responses.add(response);
        }
        return responses;
    }
}

