/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.converters;

import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Marker;

public class LineMDCConverter
extends MDCConverter {
    private static final String DROP_MDC_MARKER = "DropMDC";
    private String key;
    private String defaultValue = "";
    private final String ls = System.getProperty("line.separator");

    public void start() {
        String[] keyInfo = OptionHelper.extractDefaultReplacement((String)this.getFirstOption());
        this.key = keyInfo[0];
        if (keyInfo[1] != null) {
            this.defaultValue = keyInfo[1];
        }
        super.start();
    }

    public void stop() {
        this.key = null;
        super.stop();
    }

    public String convert(ILoggingEvent event) {
        Marker marker = event.getMarker();
        if (marker != null && marker.contains(DROP_MDC_MARKER)) {
            return this.defaultValue;
        }
        Map mdcPropertyMap = event.getMDCPropertyMap();
        if (mdcPropertyMap == null || mdcPropertyMap.isEmpty()) {
            return this.defaultValue;
        }
        if (this.key == null) {
            return this.outputMDCForAllKeys(mdcPropertyMap);
        }
        String value = (String)mdcPropertyMap.get(this.key);
        if (null == value) {
            return this.defaultValue;
        }
        StringBuilder buf = new StringBuilder(32);
        LineMDCConverter.sanitizeString(value, buf);
        return buf.toString();
    }

    private String outputMDCForAllKeys(Map<String, String> mdcPropertyMap) {
        StringBuilder buf = new StringBuilder(1250);
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(mdcPropertyMap).entrySet()) {
            String name = entry.getKey();
            if ("__threadId".equals(name)) continue;
            buf.append(' ').append(name).append('=');
            LineMDCConverter.sanitizeString(entry.getValue(), buf);
            buf.append(this.ls);
        }
        return buf.toString();
    }

    private static void sanitizeString(String str, StringBuilder buf) {
        int codePoint;
        if (LineMDCConverter.isEmpty(str)) {
            return;
        }
        int length = str.length();
        block3: for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    continue block3;
                }
            }
            buf.append(Character.toChars(codePoint));
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = LineMDCConverter.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u000e': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }
}

