/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.scripting.rhino.libs;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class Underscore {
	private static final String UNDERSCORE = "// Underscore.js 1.1.7\n" +
			"// (c) 2011 Jeremy Ashkenas, DocumentCloud Inc.\n" +
			"// Underscore is freely distributable under the MIT license.\n" +
			"// Portions of Underscore are inspired or borrowed from Prototype,\n" +
			"// Oliver Steele's Functional, and John Resig's Micro-Templating.\n" +
			"// For all details and documentation:\n" +
			"// http://documentcloud.github.com/underscore\n" +
			"(function(){var p=this,C=p._,m={},i=Array.prototype,n=Object.prototype,f=i.slice,D=i.unshift,E=n.toString,l=n.hasOwnProperty,s=i.forEach,t=i.map,u=i.reduce,v=i.reduceRight,w=i.filter,x=i.every,y=i.some,o=i.indexOf,z=i.lastIndexOf;n=Array.isArray;var F=Object.keys,q=Function.prototype.bind,b=function(a){return new j(a)};typeof module!==\"undefined\"&&module.exports?(module.exports=b,b._=b):p._=b;b.VERSION=\"1.1.7\";var h=b.each=b.forEach=function(a,c,b){if (a!=null)if (s&&a.forEach===s)a.forEach(c,b);else if (a.length===\n" +
			"+a.length)for(var e=0,k=a.length;e<k;e++){if (e in a&&c.call(b,a[e],e,a)===m)break}else for(e in a)if (l.call(a,e)&&c.call(b,a[e],e,a)===m)break};b.map=function(a,c,b){var e=[];if (a==null)return e;if (t&&a.map===t)return a.map(c,b);h(a,function(a,g,G){e[e.length]=c.call(b,a,g,G)});return e};b.reduce=b.foldl=b.inject=function(a,c,d,e){var k=d!==void 0;a==null&&(a=[]);if (u&&a.reduce===u)return e&&(c=b.bind(c,e)),k?a.reduce(c,d):a.reduce(c);h(a,function(a,b,f){k?d=c.call(e,d,a,b,f):(d=a,k=!0)});if (!k)throw new TypeError(\"Reduce of empty array with no initial value\");\n" +
			"return d};b.reduceRight=b.foldr=function(a,c,d,e){a==null&&(a=[]);if (v&&a.reduceRight===v)return e&&(c=b.bind(c,e)),d!==void 0?a.reduceRight(c,d):a.reduceRight(c);a=(b.isArray(a)?a.slice():b.toArray(a)).reverse();return b.reduce(a,c,d,e)};b.find=b.detect=function(a,c,b){var e;A(a,function(a,g,f){if (c.call(b,a,g,f))return e=a,!0});return e};b.filter=b.select=function(a,c,b){var e=[];if (a==null)return e;if (w&&a.filter===w)return a.filter(c,b);h(a,function(a,g,f){c.call(b,a,g,f)&&(e[e.length]=a)});return e};\n" +
			"b.reject=function(a,c,b){var e=[];if (a==null)return e;h(a,function(a,g,f){c.call(b,a,g,f)||(e[e.length]=a)});return e};b.every=b.all=function(a,c,b){var e=!0;if (a==null)return e;if (x&&a.every===x)return a.every(c,b);h(a,function(a,g,f){if (!(e=e&&c.call(b,a,g,f)))return m});return e};var A=b.some=b.any=function(a,c,d){c=c||b.identity;var e=!1;if (a==null)return e;if (y&&a.some===y)return a.some(c,d);h(a,function(a,b,f){if (e|=c.call(d,a,b,f))return m});return!!e};b.include=b.contains=function(a,c){var b=\n" +
			"!1;if (a==null)return b;if (o&&a.indexOf===o)return a.indexOf(c)!=-1;A(a,function(a){if (b=a===c)return!0});return b};b.invoke=function(a,c){var d=f.call(arguments,2);return b.map(a,function(a){return(c.call?c||a:a[c]).apply(a,d)})};b.pluck=function(a,c){return b.map(a,function(a){return a[c]})};b.max=function(a,c,d){if (!c&&b.isArray(a))return Math.max.apply(Math,a);var e={computed:-Infinity};h(a,function(a,b,f){b=c?c.call(d,a,b,f):a;b>=e.computed&&(e={value:a,computed:b})});return e.value};b.min=function(a,\n" +
			"c,d){if (!c&&b.isArray(a))return Math.min.apply(Math,a);var e={computed:Infinity};h(a,function(a,b,f){b=c?c.call(d,a,b,f):a;b<e.computed&&(e={value:a,computed:b})});return e.value};b.sortBy=function(a,c,d){return b.pluck(b.map(a,function(a,b,f){return{value:a,criteria:c.call(d,a,b,f)}}).sort(function(a,b){var c=a.criteria,d=b.criteria;return c<d?-1:c>d?1:0}),\"value\")};b.groupBy=function(a,b){var d={};h(a,function(a,f){var g=b(a,f);(d[g]||(d[g]=[])).push(a)});return d};b.sortedIndex=function(a,c,d){d||\n" +
			"(d=b.identity);for(var e=0,f=a.length;e<f;){var g=e+f>>1;d(a[g])<d(c)?e=g+1:f=g}return e};b.toArray=function(a){if (!a)return[];if (a.toArray)return a.toArray();if (b.isArray(a))return f.call(a);if (b.isArguments(a))return f.call(a);return b.values(a)};b.size=function(a){return b.toArray(a).length};b.first=b.head=function(a,b,d){return b!=null&&!d?f.call(a,0,b):a[0]};b.rest=b.tail=function(a,b,d){return f.call(a,b==null||d?1:b)};b.last=function(a){return a[a.length-1]};b.compact=function(a){return b.filter(a,\n" +
			"function(a){return!!a})};b.flatten=function(a){return b.reduce(a,function(a,d){if (b.isArray(d))return a.concat(b.flatten(d));a[a.length]=d;return a},[])};b.without=function(a){return b.difference(a,f.call(arguments,1))};b.uniq=b.unique=function(a,c){return b.reduce(a,function(a,e,f){if (0==f||(c===!0?b.last(a)!=e:!b.include(a,e)))a[a.length]=e;return a},[])};b.union=function(){return b.uniq(b.flatten(arguments))};b.intersection=b.intersect=function(a){var c=f.call(arguments,1);return b.filter(b.uniq(a),\n" +
			"function(a){return b.every(c,function(c){return b.indexOf(c,a)>=0})})};b.difference=function(a,c){return b.filter(a,function(a){return!b.include(c,a)})};b.zip=function(){for(var a=f.call(arguments),c=b.max(b.pluck(a,\"length\")),d=Array(c),e=0;e<c;e++)d[e]=b.pluck(a,\"\"+e);return d};b.indexOf=function(a,c,d){if (a==null)return-1;var e;if (d)return d=b.sortedIndex(a,c),a[d]===c?d:-1;if (o&&a.indexOf===o)return a.indexOf(c);d=0;for(e=a.length;d<e;d++)if (a[d]===c)return d;return-1};b.lastIndexOf=function(a,\n" +
			"b){if (a==null)return-1;if (z&&a.lastIndexOf===z)return a.lastIndexOf(b);for(var d=a.length;d--;)if (a[d]===b)return d;return-1};b.range=function(a,b,d){arguments.length<=1&&(b=a||0,a=0);d=arguments[2]||1;for(var e=Math.max(Math.ceil((b-a)/d),0),f=0,g=Array(e);f<e;)g[f++]=a,a+=d;return g};b.bind=function(a,b){if (a.bind===q&&q)return q.apply(a,f.call(arguments,1));var d=f.call(arguments,2);return function(){return a.apply(b,d.concat(f.call(arguments)))}};b.bindAll=function(a){var c=f.call(arguments,1);\n" +
			"c.length==0&&(c=b.functions(a));h(c,function(c){a[c]=b.bind(a[c],a)});return a};b.memoize=function(a,c){var d={};c||(c=b.identity);return function(){var b=c.apply(this,arguments);return l.call(d,b)?d[b]:d[b]=a.apply(this,arguments)}};b.delay=function(a,b){var d=f.call(arguments,2);return setTimeout(function(){return a.apply(a,d)},b)};b.defer=function(a){return b.delay.apply(b,[a,1].concat(f.call(arguments,1)))};var B=function(a,b,d){var e;return function(){var f=this,g=arguments,h=function(){e=null;\n" +
			"a.apply(f,g)};d&&clearTimeout(e);if (d||!e)e=setTimeout(h,b)}};b.throttle=function(a,b){return B(a,b,!1)};b.debounce=function(a,b){return B(a,b,!0)};b.once=function(a){var b=!1,d;return function(){if (b)return d;b=!0;return d=a.apply(this,arguments)}};b.wrap=function(a,b){return function(){var d=[a].concat(f.call(arguments));return b.apply(this,d)}};b.compose=function(){var a=f.call(arguments);return function(){for(var b=f.call(arguments),d=a.length-1;d>=0;d--)b=[a[d].apply(this,b)];return b[0]}};b.after=\n" +
			"function(a,b){return function(){if (--a<1)return b.apply(this,arguments)}};b.keys=F||function(a){if (a!==Object(a))throw new TypeError(\"Invalid object\");var b=[],d;for(d in a)l.call(a,d)&&(b[b.length]=d);return b};b.values=function(a){return b.map(a,b.identity)};b.functions=b.methods=function(a){var c=[],d;for(d in a)b.isFunction(a[d])&&c.push(d);return c.sort()};b.extend=function(a){h(f.call(arguments,1),function(b){for(var d in b)b[d]!==void 0&&(a[d]=b[d])});return a};b.defaults=function(a){h(f.call(arguments,\n" +
			"1),function(b){for(var d in b)a[d]==null&&(a[d]=b[d])});return a};b.clone=function(a){return b.isArray(a)?a.slice():b.extend({},a)};b.tap=function(a,b){b(a);return a};b.isEqual=function(a,c){if (a===c)return!0;var d=typeof a;if (d!=typeof c)return!1;if (a==c)return!0;if (!a&&c||a&&!c)return!1;if (a._chain)a=a._wrapped;if (c._chain)c=c._wrapped;if (a.isEqual)return a.isEqual(c);if (c.isEqual)return c.isEqual(a);if (b.isDate(a)&&b.isDate(c))return a.getTime()===c.getTime();if (b.isNaN(a)&&b.isNaN(c))return!1;\n" +
			"if (b.isRegExp(a)&&b.isRegExp(c))return a.source===c.source&&a.global===c.global&&a.ignoreCase===c.ignoreCase&&a.multiline===c.multiline;if (d!==\"object\")return!1;if (a.length&&a.length!==c.length)return!1;d=b.keys(a);var e=b.keys(c);if (d.length!=e.length)return!1;for(var f in a)if (!(f in c)||!b.isEqual(a[f],c[f]))return!1;return!0};b.isEmpty=function(a){if (b.isArray(a)||b.isString(a))return a.length===0;for(var c in a)if (l.call(a,c))return!1;return!0};b.isElement=function(a){return!!(a&&a.nodeType==\n" +
			"1)};b.isArray=n||function(a){return E.call(a)===\"[object Array]\"};b.isObject=function(a){return a===Object(a)};b.isArguments=function(a){return!(!a||!l.call(a,\"callee\"))};b.isFunction=function(a){return!(!a||!a.constructor||!a.call||!a.apply)};b.isString=function(a){return!!(a===\"\"||a&&a.charCodeAt&&a.substr)};b.isNumber=function(a){return!!(a===0||a&&a.toExponential&&a.toFixed)};b.isNaN=function(a){return a!==a};b.isBoolean=function(a){return a===!0||a===!1};b.isDate=function(a){return!(!a||!a.getTimezoneOffset||\n" +
			"!a.setUTCFullYear)};b.isRegExp=function(a){return!(!a||!a.test||!a.exec||!(a.ignoreCase||a.ignoreCase===!1))};b.isNull=function(a){return a===null};b.isUndefined=function(a){return a===void 0};b.noConflict=function(){p._=C;return this};b.identity=function(a){return a};b.times=function(a,b,d){for(var e=0;e<a;e++)b.call(d,e)};b.mixin=function(a){h(b.functions(a),function(c){H(c,b[c]=a[c])})};var I=0;b.uniqueId=function(a){var b=I++;return a?a+b:b};b.templateSettings={evaluate:/<%([\\s\\S]+?)%>/g,interpolate:/<%=([\\s\\S]+?)%>/g};\n" +
			"b.template=function(a,c){var d=b.templateSettings;d=\"var __p=[],print=function(){__p.push.apply(__p,arguments);};with(obj||{}){__p.push('\"+a.replace(/\\\\/g,\"\\\\\\\\\").replace(/'/g,\"\\\\'\").replace(d.interpolate,function(a,b){return\"',\"+b.replace(/\\\\'/g,\"'\")+\",'\"}).replace(d.evaluate||null,function(a,b){return\"');\"+b.replace(/\\\\'/g,\"'\").replace(/[\\r\\n\\t]/g,\" \")+\"__p.push('\"}).replace(/\\r/g,\"\\\\r\").replace(/\\n/g,\"\\\\n\").replace(/\\t/g,\"\\\\t\")+\"');}return __p.join('');\";d=new Function(\"obj\",d);return c?d(c):d};\n" +
			"var j=function(a){this._wrapped=a};b.prototype=j.prototype;var r=function(a,c){return c?b(a).chain():a},H=function(a,c){j.prototype[a]=function(){var a=f.call(arguments);D.call(a,this._wrapped);return r(c.apply(b,a),this._chain)}};b.mixin(b);h([\"pop\",\"push\",\"reverse\",\"shift\",\"sort\",\"splice\",\"unshift\"],function(a){var b=i[a];j.prototype[a]=function(){b.apply(this._wrapped,arguments);return r(this._wrapped,this._chain)}});h([\"concat\",\"join\",\"slice\"],function(a){var b=i[a];j.prototype[a]=function(){return r(b.apply(this._wrapped,\n" +
			"arguments),this._chain)}});j.prototype.chain=function(){this._chain=!0;return this};j.prototype.value=function(){return this._wrapped}})();";

	public static final void initialize(Scriptable s) {
		try {
			Context cx = Context.enter();
			cx.evaluateString(s, UNDERSCORE, "underscore", 1, null);
		} finally {
			Context.exit();
		}
	}
}
