/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.URLTemplate;
import com.box.sdk.internal.utils.CollectionUtils;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@BoxResourceType(value="webhook")
public class BoxWebHook
extends BoxResource {
    private static final String JSON_KEY_ID = "id";
    private static final String JSON_KEY_TARGET = "target";
    private static final String JSON_KEY_TARGET_TYPE = "type";
    private static final String JSON_KEY_TARGET_ID = "id";
    private static final String JSON_KEY_ADDRESS = "address";
    private static final String JSON_KEY_TRIGGERS = "triggers";
    private static final URLTemplate WEBHOOKS_URL_TEMPLATE = new URLTemplate("webhooks");
    private static final URLTemplate WEBHOOK_URL_TEMPLATE = new URLTemplate("webhooks/%s");
    private static final CollectionUtils.Mapper<String, Trigger> TRIGGER_TO_VALUE = new CollectionUtils.Mapper<String, Trigger>(){

        @Override
        public String map(Trigger input) {
            return input.getValue();
        }
    };
    private static final CollectionUtils.Mapper<Trigger, JsonValue> JSON_VALUE_TO_TRIGGER = new CollectionUtils.Mapper<Trigger, JsonValue>(){

        @Override
        public Trigger map(JsonValue value) {
            return Trigger.fromValue(value.asString());
        }
    };

    public BoxWebHook(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxResource target, URL address, Trigger ... triggers) {
        return BoxWebHook.create(target, address, new HashSet<Trigger>(Arrays.asList(triggers)));
    }

    public static Info create(BoxResource target, URL address, Set<Trigger> triggers) {
        BoxWebHook webHook;
        BoxAPIConnection api = target.getAPI();
        String type = BoxResource.getResourceType(target.getClass());
        BoxWebHook.validateTriggers(type, triggers);
        JsonObject targetJSON = new JsonObject().add(JSON_KEY_TARGET_TYPE, type).add("id", target.getID());
        JsonObject requestJSON = new JsonObject().add(JSON_KEY_TARGET, (JsonValue)targetJSON).add(JSON_KEY_ADDRESS, address.toExternalForm()).add(JSON_KEY_TRIGGERS, (JsonValue)BoxWebHook.toJsonArray(CollectionUtils.map(triggers, TRIGGER_TO_VALUE)));
        URL url = WEBHOOKS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxWebHook boxWebHook = webHook = new BoxWebHook(api, responseJSON.get("id").asString());
        boxWebHook.getClass();
        return boxWebHook.new Info(responseJSON);
    }

    private static JsonArray toJsonArray(Collection<String> values) {
        JsonArray array = new JsonArray();
        for (String value : values) {
            array.add(value);
        }
        return array;
    }

    public static Iterable<Info> all(final BoxAPIConnection api) {
        return new BoxResourceIterable<Info>(api, WEBHOOKS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]), 64){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxWebHook webHook;
                BoxWebHook boxWebHook = webHook = new BoxWebHook(api, jsonObject.get("id").asString());
                boxWebHook.getClass();
                return boxWebHook.new Info(jsonObject);
            }
        };
    }

    public static void validateTriggers(String targetType, Collection<Trigger> triggers) {
        for (Trigger trigger : triggers) {
            BoxWebHook.validateTrigger(targetType, trigger);
        }
    }

    private static void validateTrigger(String targetType, Trigger trigger) {
        for (String type : trigger.getTypes()) {
            if (!targetType.equals(type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Provided trigger '%s' is not supported on provided target '%s'.", trigger.name(), targetType));
    }

    public Info getInfo() {
        URL url = WEBHOOK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(JsonObject.readFrom((String)response.getJSON()));
    }

    public void updateInfo(Info info) {
        URL url = WEBHOOK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public void delete() {
        URL url = WEBHOOK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public static enum Trigger {
        FOLDER_CREATED("FOLDER.CREATED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_COPIED("FOLDER.COPIED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_MOVED("FOLDER.MOVED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_DOWNLOADED("FOLDER.DOWNLOADED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_RESTORED("FOLDER.RESTORED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_DELETED("FOLDER.DELETED", BoxResource.getResourceType(BoxFolder.class)),
        FILE_UPLOADED("FILE.UPLOADED", BoxResource.getResourceType(BoxFolder.class)),
        FILE_COPIED("FILE.COPIED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_MOVED("FILE.MOVED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_PREVIEWED("FILE.PREVIEWED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_DOWNLOADED("FILE.DOWNLOADED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_LOCKED("FILE.LOCKED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_UNLOCKED("FILE.UNLOCKED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_TRASHED("FILE.TRASHED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_RESTORED("FILE.RESTORED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_DELETED("FILE.DELETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        COMMENT_CREATED("COMMENT.CREATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        COMMENT_UPDATED("COMMENT.UPDATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        COMMENT_DELETED("COMMENT.DELETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class));

        private final String value;
        private final String[] types;

        private Trigger(String value, String ... types) {
            this.value = value;
            this.types = types;
        }

        public String getValue() {
            return this.value;
        }

        public static Trigger fromValue(String value) {
            for (Trigger trigger : Trigger.values()) {
                if (!trigger.getValue().equals(value)) continue;
                return trigger;
            }
            throw new IllegalArgumentException("No Trigger for value: " + value);
        }

        public String[] getTypes() {
            return this.types;
        }
    }

    public static class Target {
        private final String type;
        private final String id;

        public Target(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }

    public class Info
    extends BoxResource.Info {
        private Target target;
        private URL address;
        private Set<Trigger> triggers;

        public Info() {
            this.target = BoxWebHook.this.getInfo().getTarget();
        }

        public Info(JsonObject jsonObject) {
            super(jsonObject);
            if (jsonObject.get(BoxWebHook.JSON_KEY_TARGET) != null) {
                JsonObject targetObject = jsonObject.get(BoxWebHook.JSON_KEY_TARGET).asObject();
                String targetType = targetObject.get(BoxWebHook.JSON_KEY_TARGET_TYPE).asString();
                String targetId = targetObject.get("id").asString();
                this.target = new Target(targetType, targetId);
            }
            if (jsonObject.get(BoxWebHook.JSON_KEY_TRIGGERS) != null) {
                this.triggers = new HashSet(CollectionUtils.map(jsonObject.get(BoxWebHook.JSON_KEY_TRIGGERS).asArray().values(), JSON_VALUE_TO_TRIGGER));
            }
            if (jsonObject.get(BoxWebHook.JSON_KEY_ADDRESS) != null) {
                try {
                    this.address = new URL(jsonObject.get(BoxWebHook.JSON_KEY_ADDRESS).asString());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public BoxWebHook getResource() {
            return BoxWebHook.this;
        }

        public Target getTarget() {
            return this.target;
        }

        public URL getAddress() {
            return this.address;
        }

        public Info setAddress(URL address) {
            if (address == null) {
                throw new IllegalArgumentException("Address cannot be null");
            }
            if (this.address == null || !this.address.equals(address)) {
                this.address = address;
                this.addPendingChange(BoxWebHook.JSON_KEY_ADDRESS, address.toExternalForm());
            }
            return this;
        }

        public Set<Trigger> getTriggers() {
            return this.triggers;
        }

        public Info setTriggers(Trigger ... triggers) {
            return this.setTriggers(new HashSet<Trigger>(Arrays.asList(triggers)));
        }

        public Info setTriggers(Set<Trigger> triggers) {
            BoxWebHook.validateTriggers(this.target.getType(), triggers);
            JsonArray oldValue = this.triggers != null ? BoxWebHook.toJsonArray(CollectionUtils.map(this.triggers, TRIGGER_TO_VALUE)) : null;
            JsonArray newValue = BoxWebHook.toJsonArray(CollectionUtils.map(triggers, TRIGGER_TO_VALUE));
            if (!newValue.equals((Object)oldValue)) {
                this.triggers = Collections.unmodifiableSet(triggers);
                this.addPendingChange(BoxWebHook.JSON_KEY_TRIGGERS, newValue);
            }
            return this;
        }
    }
}

