/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nonblocking;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketReaderInitializer;
import com.hazelcast.internal.networking.nonblocking.AbstractHandler;
import com.hazelcast.internal.networking.nonblocking.NonBlockingIOThread;
import com.hazelcast.internal.networking.nonblocking.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class NonBlockingSocketReader
extends AbstractHandler
implements SocketReader {
    protected ByteBuffer inputBuffer;
    @Probe(name="bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private ReadHandler readHandler;
    private volatile long lastReadTime;
    private final SocketReaderInitializer initializer;
    private final ByteBuffer protocolBuffer = ByteBuffer.allocate(3);

    public NonBlockingSocketReader(SocketConnection connection, NonBlockingIOThread ioThread, ILogger logger, IOBalancer balancer, SocketReaderInitializer initializer) {
        super(connection, ioThread, 1, logger, balancer);
        this.initializer = initializer;
    }

    @Override
    public ByteBuffer getProtocolBuffer() {
        return this.protocolBuffer;
    }

    @Override
    public void initInputBuffer(ByteBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    @Override
    public void initReadHandler(ReadHandler readHandler) {
        this.readHandler = readHandler;
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    @Override
    public SwCounter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    @Override
    public SwCounter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Override
    public void init() {
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    NonBlockingSocketReader.this.getSelectionKey();
                }
                catch (Throwable t) {
                    NonBlockingSocketReader.this.onFailure(t);
                }
            }
        });
    }

    @Override
    public void requestMigration(NonBlockingIOThread newOwner) {
        this.ioThread.addTaskAndWakeup(new StartMigrationTask(newOwner));
    }

    @Override
    public void handle() throws Exception {
        int readBytes;
        this.eventCount.inc();
        this.lastReadTime = System.currentTimeMillis();
        if (this.readHandler == null) {
            this.initializer.init(this.connection, this);
            if (this.readHandler == null) {
                return;
            }
        }
        if ((readBytes = this.socketChannel.read(this.inputBuffer)) <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.readHandler.onRead(this.inputBuffer);
        if (this.inputBuffer.hasRemaining()) {
            this.inputBuffer.compact();
        } else {
            this.inputBuffer.clear();
        }
    }

    @Override
    public void close() {
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                if (NonBlockingSocketReader.this.ioThread != Thread.currentThread()) {
                    NonBlockingSocketReader.this.ioThread.addTaskAndWakeup(this);
                    return;
                }
                try {
                    NonBlockingSocketReader.this.socketChannel.closeInbound();
                }
                catch (IOException e) {
                    NonBlockingSocketReader.this.logger.finest("Error while closing inbound", e);
                }
            }
        });
    }

    public String toString() {
        return this.connection + ".socketReader";
    }

    private class StartMigrationTask
    implements Runnable {
        private final NonBlockingIOThread newOwner;

        StartMigrationTask(NonBlockingIOThread newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public void run() {
            if (NonBlockingSocketReader.this.ioThread == this.newOwner) {
                return;
            }
            try {
                NonBlockingSocketReader.this.startMigration(this.newOwner);
            }
            catch (Throwable t) {
                NonBlockingSocketReader.this.onFailure(t);
            }
        }
    }
}

