/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.UTFEncoderDecoder;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationContextAware;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class ObjectDataOutputStream
extends OutputStream
implements ObjectDataOutput,
Closeable,
SerializationContextAware {
    private final SerializationService serializationService;
    private final DataOutputStream dataOut;
    private final ByteOrder byteOrder;
    private final byte[] utfBuffer = new byte[1024];

    public ObjectDataOutputStream(OutputStream outputStream, SerializationService serializationService) {
        this(outputStream, serializationService, ByteOrder.BIG_ENDIAN);
    }

    public ObjectDataOutputStream(OutputStream outputStream, SerializationService serializationService, ByteOrder byteOrder) {
        this.serializationService = serializationService;
        this.dataOut = new DataOutputStream(outputStream);
        this.byteOrder = byteOrder;
    }

    @Override
    public void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOut.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataOut.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataOut.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.bigEndian()) {
            this.dataOut.writeShort(v);
        } else {
            this.dataOut.writeShort(Short.reverseBytes((short)v));
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.bigEndian()) {
            this.dataOut.writeChar(v);
        } else {
            this.dataOut.writeChar(Character.reverseBytes((char)v));
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.bigEndian()) {
            this.dataOut.writeInt(v);
        } else {
            this.dataOut.writeInt(Integer.reverseBytes(v));
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.bigEndian()) {
            this.dataOut.writeLong(v);
        } else {
            this.dataOut.writeLong(Long.reverseBytes(v));
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.bigEndian()) {
            this.dataOut.writeFloat(v);
        } else {
            this.writeInt(Float.floatToIntBits(v));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.bigEndian()) {
            this.dataOut.writeDouble(v);
        } else {
            this.writeLong(Double.doubleToLongBits(v));
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataOut.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    @Override
    public void writeCharArray(char[] chars) throws IOException {
        int len = chars != null ? chars.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (char c : chars) {
                this.writeChar(c);
            }
        }
    }

    @Override
    public void writeIntArray(int[] ints) throws IOException {
        int len = ints != null ? ints.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (int i : ints) {
                this.writeInt(i);
            }
        }
    }

    @Override
    public void writeLongArray(long[] longs) throws IOException {
        int len = longs != null ? longs.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (long l : longs) {
                this.writeLong(l);
            }
        }
    }

    @Override
    public void writeDoubleArray(double[] doubles) throws IOException {
        int len = doubles != null ? doubles.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (double d : doubles) {
                this.writeDouble(d);
            }
        }
    }

    @Override
    public void writeFloatArray(float[] floats) throws IOException {
        int len = floats != null ? floats.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (float f : floats) {
                this.writeFloat(f);
            }
        }
    }

    @Override
    public void writeShortArray(short[] shorts) throws IOException {
        int len = shorts != null ? shorts.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (short s : shorts) {
                this.writeShort(s);
            }
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        UTFEncoderDecoder.writeUTF(this, str, this.utfBuffer);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dataOut.write(b);
    }

    @Override
    public void writeObject(Object object) throws IOException {
        this.serializationService.writeObject(this, object);
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        this.dataOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.dataOut.close();
    }

    @Override
    public SerializationContext getSerializationContext() {
        return this.serializationService.getSerializationContext();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private boolean bigEndian() {
        return this.byteOrder == ByteOrder.BIG_ENDIAN;
    }
}

