/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.client.onboarding.mail;

import com.openexchange.mail.api.MailConfig;

/**
 * {@link MailConfigMailSettings}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.10.3
 */
public class MailConfigMailSettings implements MailSettings {

    private final MailConfig mailConfig;

    /**
     * Initializes a new {@link MailConfigMailSettings}.
     */
    public MailConfigMailSettings(MailConfig mailConfig) {
        super();
        this.mailConfig = mailConfig;
    }

    @Override
    public String getLogin() {
        return mailConfig.getLogin();
    }

    @Override
    public String getPassword() {
        return mailConfig.getPassword();
    }

    @Override
    public int getPort() {
        return mailConfig.getPort();
    }

    @Override
    public String getServer() {
        return mailConfig.getServer();
    }

    @Override
    public boolean isSecure() {
        return mailConfig.isSecure();
    }

    @Override
    public boolean isRequireTls() {
        return mailConfig.isRequireTls();
    }

}
