/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.admin.user.copy.osgi;

import java.rmi.Remote;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.openexchange.admin.user.copy.rmi.impl.OXUserCopy;
import com.openexchange.user.copy.UserCopyService;

/**
 * Registers the RMI user copy interface.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class RMIUserCopyRegisterer implements ServiceTrackerCustomizer<UserCopyService,UserCopyService> {

    private static final org.slf4j.Logger LOG = org.slf4j.LoggerFactory.getLogger(RMIUserCopyRegisterer.class);

    private final BundleContext context;

    private ServiceRegistration<Remote> registration;

    public RMIUserCopyRegisterer(final BundleContext context) {
        super();
        this.context = context;
    }

    @Override
    public UserCopyService addingService(final ServiceReference<UserCopyService> reference) {
        final UserCopyService service = context.getService(reference);
        {
            Dictionary<String, Object> serviceProperties = new Hashtable<String, Object>(1);
            serviceProperties.put("RMI_NAME", OXUserCopy.RMI_NAME);
            registration = context.registerService(Remote.class, new OXUserCopy(service), serviceProperties);
            LOG.info("RMI Interface for usercopy bundle bound to RMI registry");
        }
        return service;
    }

    @Override
    public void modifiedService(final ServiceReference<UserCopyService> reference, final UserCopyService service) {
        // Nothing to do.
    }

    @Override
    public void removedService(final ServiceReference<UserCopyService> reference, final UserCopyService service) {
        try {
            if (null != registration) {
                LOG.info("RMI Interface for usercopy bundle removed from RMI registry");
                registration.unregister();
                registration = null;
            }
            context.ungetService(reference);
        } catch (Exception e) {
            LOG.error("", e);
        }
    }
}
