/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Richard Petersen <richard.petersen@open-xchange.com>
 *
 */

(function () {
    window.tinymce.PluginManager.add('oxpaste', function (editor) {
        /*
        * React on pasted images. This is mainly for chrome support
        */
        editor.on('paste', function (e) {
            var clipboard = (e.clipboardData || (e.originalEvent && e.originalEvent.clipboardData) || window.clipboardData);

            if (clipboard) {
                var items = clipboard.items;
                _(items).each(function (item) {
                    // skip non-images
                    if (!/^image/.test(item.type)) return;
                    var file = item.getAsFile();
                    _.defer(function () {
                        editor.plugins.oximage.uploadBlob(file, { from_clipboard: true });
                    });
                    // prevent default when an image is pasted to prevent duplication
                    // when using the copy picture function the picture is added to the clipboard object as html and image. We only need the image part.
                    e.preventDefault();
                });
            }
        });

        /*
        * Process pasted images with encoded url.
        * Those images are inserted with local object url url and uploaded meanwhile. After upload, the url is replaced.
        */
        // only debounce for non ie browsers
        var wrapper = !!_.browser.ie && !_.browser.edge ? function (cb) { return cb; } : _.debounce;
        editor.on('PastePostProcess', wrapper(function (e) {
            $('img', $(e.node)).each(function (index, elem) {
                var $elem = $(elem),
                    src = $elem.attr('src');

                if (/^data:/.test(src)) {
                    // Some browsers directly inserts base64 encoded images.
                    var byteString = atob(src.split(',')[1]),
                        mimeString = src.split(',')[0].split(':')[1].split(';')[0],
                        buffer = new window.ArrayBuffer(byteString.length),
                        intArray = new window.Uint8Array(buffer);

                    for (var i = 0; i < byteString.length; i++) {
                        intArray[i] = byteString.charCodeAt(i);
                    }

                    // uploads and inserts the image
                    if (intArray.length) editor.plugins.oximage.uploadBlob(new Blob([intArray], { type: mimeString }));
                } else if (src.indexOf('webkit-fake-url') !== -1) {
                    // Safari uses webkit-fake-urls instead of base64 encoded urls, which disallows image data access
                    require(['io.ox/core/notifications', 'gettext!io.ox/mail'], function (notifications, gt) {
                        notifications.yell('warning', gt('Pasting images is not supported by your browser!'));
                    });
                } else if ($elem.attr('data-pending') && !$elem.attr('from_clipboard')) {
                    // this image is already uploading and needs to be previewed
                    // if inserted from clipboard the uploadblob function handles this already
                    editor.plugins.oximage.addImage({ src: src, id: $elem.attr('id') });
                }
            });
        }, 0));
    });
}());
