/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.ox_json.osgi;

import com.openexchange.usm.api.configuration.ConfigurationManager;
import com.openexchange.usm.api.configuration.ConfigurationProperties;
import com.openexchange.usm.api.exceptions.USMInvalidConfigurationException;
import com.openexchange.usm.api.exceptions.USMStartupException;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.ox_json.impl.OXJSONAccessImpl;
import com.openexchange.usm.ox_json.impl.OXJSONErrorCode;
import com.openexchange.usm.util.AbstractUSMActivator;


/**
 * {@link OXJSONAccessActivator}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class OXJSONAccessActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[]{ConfigurationManager.class};
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        ConfigurationManager cm = (ConfigurationManager) context.getService(presentServices.get(ConfigurationManager.class));
        
        try {
            String accessUrl = cm.getProperty(ConfigurationProperties.OX_ACCESS_URL_PROPERTY,
                    ConfigurationProperties.OX_ACCESS_URL_DEFAULT, true);
            int maxConnections = cm.getProperty(
                ConfigurationProperties.OX_ACCESS_MAX_CONNECTIONS_PROPERTY,
                    ConfigurationProperties.OX_ACCESS_MAX_CONNECTIONS_DEFAULT, false);
            int connectionTimeout = cm.getProperty(
                ConfigurationProperties.OX_ACCESS_CONNECTION_TIMEOUT_PROPERTY,
                    ConfigurationProperties.OX_ACCESS_CONNECTION_TIMEOUT_DEFAULT, false);
            boolean performStaleChecking = cm.getProperty(
                ConfigurationProperties.OX_ACCESS_PERFORM_STALE_CHECKING_PROPERTY,
                    ConfigurationProperties.OX_ACCESS_PERFORM_STALE_CHECKING_DEFAULT, false);
            boolean staySignedIn = cm.getProperty(
                ConfigurationProperties.OX_ACCESS_STAY_SIGNED_IN_PROPERTY,
                    ConfigurationProperties.OX_ACCESS_STAY_SIGNED_IN_DEFAULT, true);
            boolean passHostHeaderFromClient = cm.getProperty(
                ConfigurationProperties.OX_ACCESS_PASS_HOST_HEADER_FROM_CLIENT,
                    ConfigurationProperties.OX_ACCESS_PASS_HOST_HEADER_FROM_CLIENT_DEFAULT, false);
            String reloginErrorCodes = cm.getProperty(
                ConfigurationProperties.OX_ACCESS_RELOGIN_ERROR_CODES_PROPERTY,
                    ConfigurationProperties.OX_ACCESS_RELOGIN_ERROR_CODES_DEFAULT, false);
            String missingObjectErrorCodes = cm.getProperty(
                    ConfigurationProperties.OX_ACCESS_MISSING_OBJECT_ERROR_CODES_PROPERTY,
                        ConfigurationProperties.OX_ACCESS_MISSING_OBJECT_ERROR_CODES_DEFAULT, false);
            OXJSONAccess jsonAccess = new OXJSONAccessImpl(accessUrl, maxConnections, connectionTimeout, performStaleChecking, staySignedIn, passHostHeaderFromClient, reloginErrorCodes, missingObjectErrorCodes);
            registerService(OXJSONAccess.class, jsonAccess);
            LOG.info("OXJSONAccess registered.");
        } catch (USMInvalidConfigurationException e) {
            throw new USMStartupException(OXJSONErrorCode.CONFIGURATION_ERROR,
                    "Could't read OX server access properties", e);
        }
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        OXJSONAccessImpl o = (OXJSONAccessImpl) getRegisteredService(OXJSONAccess.class);
        if (o != null)
            o.deactivate();
        LOG.info("OXJSONAccess unregistered.");
    }

}
