/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.exceptions;

import org.json.JSONObject;

/**
 * Exception that is generated if authentication on the OX server failed.<br>
 * Details about the failed authentication are stored in a JSONObject. This is either
 * directly the JSONObject returned from the OX server, or if the result could not be
 * parsed into a JSONObject, a JSONObject containing two fields:<br>
 * <ul>
 * <li>error: Error message from the OXJSONAccess service
 * <li>data: data returned from the OX server, either a JSONArray (if it could be parsed
 * as such an array), or a String containing the response
 * </ul>
 * Note that on severe communication problems (No http OK(200) status code or
 * HttpException/IOException) a OXCommunicationException is thrown.
 * 
 * @author afe
 *
 */
public class AuthenticationFailedException extends USMException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final JSONObject _errorDetails;

	public AuthenticationFailedException(int errorCode, String message, JSONObject errorDetails) {
		super(errorCode, message);
		_errorDetails = errorDetails;
	}

	public JSONObject getErrorDetails() {
		return _errorDetails;
	}

	@Override
	public JSONObject getOxErrorForJSONResponse() {
		return _errorDetails;
	}

	@Override
	public JSONObject getErrorDetailsForJSONResponse() {
		return null;
	}

	@Override
    public String getErrorMessage() {
        String message = super.getMessage();
        if (_errorDetails != null) {
            if (message == null) {
                message = _errorDetails.toString();
            }
            else {
                message = super.getMessage() + ": " + _errorDetails.toString();
            }
        }
        return message;
    }

	@Override
    public String getMessage() {
        return getErrorMessage();
    }

	@Override
	public String toString() {
		String superToString = super.toString();
		if (_errorDetails == null)
			return superToString;
		return superToString + ':' + _errorDetails;
	}
}
