package com.openexchange.office.tools.service.validation.validator;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.office.tools.service.validation.annotation.OneOfMustNotBeNull;

public class OneOfMustNotBeNullValidator implements ConstraintValidator<OneOfMustNotBeNull, Object> {

	private static final Logger log = LoggerFactory.getLogger(OneOfMustNotBeNullValidator.class);
	
	private Set<String> attributes = new HashSet<>();
	
	@Override
	public void initialize(OneOfMustNotBeNull constraintAnnotation) {
		for (String str : constraintAnnotation.attributesToValidate()) {
			attributes.add(str);
		}
	}

	@Override
	public boolean isValid(Object obj, ConstraintValidatorContext ctx) {
		boolean foundNotNullValue = false;
		for (String attributeName : attributes) {
			try {
				Field field = obj.getClass().getDeclaredField(attributeName);
				field.setAccessible(true);
				foundNotNullValue = field.get(obj) != null;
				if (foundNotNullValue) {
					return true;
				}
			} catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException e) {
				log.error(e.getMessage(), e);
				throw new RuntimeException(e);
			}
		}
		return false;
	}	
}
