package com.openexchange.office.tools.service.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE_USE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.openexchange.office.tools.service.validation.annotation.PositiveOrZero.List;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForBigDecimal;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForBigInteger;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForByte;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForDouble;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForFloat;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForInteger;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForLong;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForNumber;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomPositiveOrZeroValidatorForShort;

/**
 * The annotated element must be a positive number or 0.
 * <p>
 * Supported types are:
 * <ul>
 *     <li>{@code BigDecimal}</li>
 *     <li>{@code BigInteger}</li>
 *     <li>{@code byte}, {@code short}, {@code int}, {@code long}, {@code float},
 *     {@code double} and their respective wrappers</li>
 * </ul>
 * <p>
 * {@code null} elements are considered valid.
 *
 */
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
@Retention(RUNTIME)
@Repeatable(List.class)
@Documented
@Constraint(
		validatedBy = {CustomPositiveOrZeroValidatorForBigDecimal.class, CustomPositiveOrZeroValidatorForBigInteger.class, CustomPositiveOrZeroValidatorForByte.class,
					   CustomPositiveOrZeroValidatorForDouble.class, CustomPositiveOrZeroValidatorForFloat.class, CustomPositiveOrZeroValidatorForInteger.class,
					   CustomPositiveOrZeroValidatorForLong.class, CustomPositiveOrZeroValidatorForNumber.class, CustomPositiveOrZeroValidatorForShort.class})
public @interface PositiveOrZero {

	String message() default "{javax.validation.constraints.PositiveOrZero.message}";

	Class<?>[] groups() default { };

	Class<? extends Payload>[] payload() default { };

	/**
	 * Defines several {@link PositiveOrZero} constraints on the same element.
	 *
	 * @see PositiveOrZero
	 */
	@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
	@Retention(RUNTIME)
	@Documented
	@interface List {

		PositiveOrZero[] value();
	}
}
