package com.openexchange.office.tools.service.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE_USE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.openexchange.office.tools.service.validation.annotation.NegativeOrZero.List;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForBigDecimal;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForBigInteger;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForByte;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForDouble;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForFloat;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForInteger;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForLong;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForNumber;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeOrZeroValidatorForShort;

/**
 * The annotated element must be a negative number or 0.
 * <p>
 * Supported types are:
 * <ul>
 *     <li>{@code BigDecimal}</li>
 *     <li>{@code BigInteger}</li>
 *     <li>{@code byte}, {@code short}, {@code int}, {@code long}, {@code float},
 *     {@code double} and their respective wrappers</li>
 * </ul>
 * <p>
 * {@code null} elements are considered valid.
 *
 */
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
@Retention(RUNTIME)
@Repeatable(List.class)
@Documented
@Constraint(
	validatedBy = {CustomNegativeOrZeroValidatorForBigDecimal.class, CustomNegativeOrZeroValidatorForBigInteger.class, CustomNegativeOrZeroValidatorForByte.class,
				   CustomNegativeOrZeroValidatorForDouble.class, CustomNegativeOrZeroValidatorForFloat.class, CustomNegativeOrZeroValidatorForInteger.class,
				   CustomNegativeOrZeroValidatorForLong.class, CustomNegativeOrZeroValidatorForNumber.class, CustomNegativeOrZeroValidatorForShort.class})
public @interface NegativeOrZero {

	String message() default "{javax.validation.constraints.NegativeOrZero.message}";

	Class<?>[] groups() default { };

	Class<? extends Payload>[] payload() default { };

	/**
	 * Defines several {@link NegativeOrZero} constraints on the same element.
	 *
	 * @see NegativeOrZero
	 */
	@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
	@Retention(RUNTIME)
	@Documented
	@interface List {

		NegativeOrZero[] value();
	}
}
