package com.openexchange.office.tools.service.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE_USE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.openexchange.office.tools.service.validation.annotation.Negative.List;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForBigDecimal;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForBigInteger;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForByte;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForDouble;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForFloat;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForInteger;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForLong;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForNumber;
import com.openexchange.office.tools.service.validation.validator.number.sign.CustomNegativeValidatorForShort;

/**
 * The annotated element must be a strictly negative number (i.e. 0 is considered as an
 * invalid value).
 * <p>
 * Supported types are:
 * <ul>
 *     <li>{@code BigDecimal}</li>
 *     <li>{@code BigInteger}</li>
 *     <li>{@code byte}, {@code short}, {@code int}, {@code long}, {@code float},
 *     {@code double} and their respective wrappers</li>
 * </ul>
 * <p>
 * {@code null} elements are considered valid.
 *
 */
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
@Retention(RUNTIME)
@Repeatable(List.class)
@Documented
@Constraint(
		validatedBy = {CustomNegativeValidatorForBigDecimal.class, CustomNegativeValidatorForBigInteger.class, CustomNegativeValidatorForByte.class,
					   CustomNegativeValidatorForDouble.class, CustomNegativeValidatorForFloat.class, CustomNegativeValidatorForInteger.class,
					   CustomNegativeValidatorForLong.class, CustomNegativeValidatorForNumber.class, CustomNegativeValidatorForShort.class})
public @interface Negative {

	String message() default "{javax.validation.constraints.Negative.message}";

	Class<?>[] groups() default { };

	Class<? extends Payload>[] payload() default { };

	/**
	 * Defines several {@link Negative} constraints on the same element.
	 *
	 * @see Negative
	 */
	@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
	@Retention(RUNTIME)
	@Documented
	@interface List {

		Negative[] value();
	}
}
