package com.openexchange.office.tools.service.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE_USE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.openexchange.office.tools.service.validation.annotation.Min.List;
import com.openexchange.office.tools.service.validation.validator.CustomMinValidatorForCharSequence;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForBigDecimal;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForBigInteger;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForByte;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForDouble;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForFloat;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForInteger;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForLong;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForNumber;
import com.openexchange.office.tools.service.validation.validator.number.bound.CustomMinValidatorForShort;

/**
 * The annotated element must be a number whose value must be higher or
 * equal to the specified minimum.
 * <p>
 * Supported types are:
 * <ul>
 *     <li>{@code BigDecimal}</li>
 *     <li>{@code BigInteger}</li>
 *     <li>{@code byte}, {@code short}, {@code int}, {@code long}, and their respective
 *     wrappers</li>
 * </ul>
 * Note that {@code double} and {@code float} are not supported due to rounding errors
 * (some providers might provide some approximative support).
 * <p>
 * {@code null} elements are considered valid.
 *
 */
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
@Retention(RUNTIME)
@Repeatable(List.class)
@Documented
@Constraint(
	validatedBy = {CustomMinValidatorForCharSequence.class, CustomMinValidatorForBigDecimal.class, CustomMinValidatorForBigInteger.class, CustomMinValidatorForByte.class,
				   CustomMinValidatorForDouble.class, CustomMinValidatorForFloat.class, CustomMinValidatorForInteger.class, CustomMinValidatorForLong.class,
				   CustomMinValidatorForNumber.class, CustomMinValidatorForShort.class})
public @interface Min {

	String message() default "{javax.validation.constraints.Min.message}";

	Class<?>[] groups() default { };

	Class<? extends Payload>[] payload() default { };

	/**
	 * @return value the element must be higher or equal to
	 */
	long value();

	/**
	 * Defines several {@link Min} annotations on the same element.
	 *
	 * @see Min
	 */
	@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
	@Retention(RUNTIME)
	@Documented
	@interface List {

		Min[] value();
	}
}
