package com.openexchange.office.tools.service.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE_USE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.ClockProvider;
import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

import com.openexchange.office.tools.service.validation.annotation.Future.List;
import com.openexchange.office.tools.service.validation.validator.time.future.CustomFutureValidatorForCalendar;
import com.openexchange.office.tools.service.validation.validator.time.future.CustomFutureValidatorForDate;
import com.openexchange.office.tools.service.validation.validator.time.future.CustomFutureValidatorForLocalDate;
import com.openexchange.office.tools.service.validation.validator.time.future.CustomFutureValidatorForLocalDateTime;
import com.openexchange.office.tools.service.validation.validator.time.future.CustomFutureValidatorForLocalTime;

/**
 * The annotated element must be an instant, date or time in the future.
 * <p>
 * <i>Now</i> is defined by the {@link ClockProvider} attached to the {@link Validator} or
 * {@link ValidatorFactory}. The default {@code clockProvider} defines the current time
 * according to the virtual machine, applying the current default time zone if needed.
 * <p>
 * Supported types are:
 * <ul>
 *     <li>{@code java.util.Date}</li>
 *     <li>{@code java.util.Calendar}</li>
 *     <li>{@code java.time.LocalDate}</li>
 *     <li>{@code java.time.LocalDateTime}</li>
 *     <li>{@code java.time.LocalTime}</li>
 * </ul>
 * <p>
 * {@code null} elements are considered valid.
 *
 */
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
@Retention(RUNTIME)
@Repeatable(List.class)
@Documented
@Constraint(
	validatedBy = {CustomFutureValidatorForCalendar.class, CustomFutureValidatorForDate.class, CustomFutureValidatorForLocalDate.class,
				   CustomFutureValidatorForLocalDateTime.class, CustomFutureValidatorForLocalTime.class})
public @interface Future {

	String message() default "{javax.validation.constraints.Future.message}";

	Class<?>[] groups() default { };

	Class<? extends Payload>[] payload() default { };

	/**
	 * Defines several {@link Future} annotations on the same element.
	 *
	 * @see Future
	 */
	@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
	@Retention(RUNTIME)
	@Documented
	@interface List {

		Future[] value();
	}
}
