package com.openexchange.office.tools.service.files.impl;

import org.springframework.stereotype.Service;

import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.common.osgi.context.OsgiBundleContextAndActivator;
import com.openexchange.office.tools.common.osgi.context.OsgiBundleContextAware;
import com.openexchange.office.tools.service.files.FolderHelperService;
import com.openexchange.office.tools.service.files.FolderHelperServiceFactory;
import com.openexchange.session.Session;

@Service
@RegisteredService(registeredClass=FolderHelperServiceFactory.class)
public class FolderHelperServiceFactoryImpl implements FolderHelperServiceFactory, OsgiBundleContextAware {
	
	private OsgiBundleContextAndActivator bundleContext;

	@Override
	public FolderHelperService create(Session session) {
		FolderHelperServiceImpl folderHelperService = new FolderHelperServiceImpl(session);
		bundleContext.injectDependencies(folderHelperService);
		return folderHelperService;
	}

	@Override
	public void setApplicationContext(OsgiBundleContextAndActivator bundleCtx) {
		this.bundleContext = bundleCtx;
	}
}
