package com.openexchange.office.tools.service.conversion.impl;

import java.io.IOException;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.service.conversion.ConversionException;
import com.openexchange.office.tools.service.conversion.OfficeConverter;
import com.openexchange.office.tools.service.conversion.RequestDataIsNullException;

@Service
@RegisteredService(registeredClass=OfficeConverter.class)
public class OfficeConverterImpl implements OfficeConverter {

	private static final Logger log = LoggerFactory.getLogger(OfficeConverterImpl.class);
	
	public static final String KEY_REQUESTDATA = "requestdata";
	
	private ObjectMapper objMapper = new ObjectMapper();
	
	@Override
	public <T> T convert(AJAXRequestData requestData, Class<T> targetClass) throws ConversionException, RequestDataIsNullException {
		String requestBodyData = requestData.getParameter(KEY_REQUESTDATA);
		if (StringUtils.isBlank(requestBodyData)) {
			log.info("requestdata is blank or null");
			throw new RequestDataIsNullException();
		}
		T res; 
		try {
			res = objMapper.readValue(requestBodyData, targetClass);
			return res;
		} catch (JsonParseException | JsonMappingException e) {
			log.info(e.getMessage());
			throw new ConversionException(String.class, targetClass, e);
		} catch (IOException e) {
			log.error(e.getMessage());
			throw new RuntimeException(e);
		}
	}
}
