/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.tools.common.system;

/**
 * Helper class to access system specific information of the JVM.
 *
 * @author Carsten Driesner
 */
public class SystemInfoHelper {

    public final static long KBYTES = 1024;
    public final static long MBYTES = 1024 * 1024;
    public final static long TYPICAL_BACKEND_HEAPSPACE = 250 * MBYTES;
    public final static long MINIMAL_FREE_BACKEND_HEAPSPACE = 100 * MBYTES;

    public static class MemoryInfo {
        public long usedHeapSize = 0;
        public long maxHeapSize = 0;
        public long freeHeapSize = 0;
    }

    /**
     * Provides information about the current free heap size, the total memory
     * used by the JVM and the maximal heap size.
     *
     * @return
     *  A MemoryInfo object which contains the heap memory details or all
     *  values are zero in case the information could not be retrieved.
     */
    static public MemoryInfo getMemoryInfo() {
    	MemoryInfo memInfo = new MemoryInfo();
        memInfo.maxHeapSize = maxMemory();
        memInfo.usedHeapSize = totalMemory();
        memInfo.freeHeapSize = freeMemory();

        return memInfo;
    }

    static public long maxMemory() {
    	return Runtime.getRuntime().maxMemory();
    }

    static public long totalMemory() {
    	return Runtime.getRuntime().totalMemory();
    }

    static public long freeMemory() {
    	// Determine the current free heap space by using the possible
    	// extension for the Java VM to allocate up to max heap space (-Xmx)
    	// and the amount of free memory which only uses the current total
    	// memory size as the limit. The addition of both values should
    	// give a good assumption of the possible free heap space.
        final long freeHeapSize1 = Runtime.getRuntime().freeMemory();
        final long freeHeapSize2 = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
        return freeHeapSize1 + freeHeapSize2;
    }

    /**
     * Calculates the minimal JVM heap size we need to load a specific
     * document.
     *
     * @param filterHeapSpaceNeeded
     *  The memory needed by the filter to process the document.
     *
     * @return
     *  The minimal setting of the JVM heap size to load the document.
     */
    static public long calculateNeededHeapSize(long filterHeapSpaceNeeded) {
        return (filterHeapSpaceNeeded * 2) + TYPICAL_BACKEND_HEAPSPACE;
    }
}
