/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.common.cache;

import java.util.Map;
import java.util.UUID;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.hazelcast.core.HazelcastInstance;

//=============================================================================
/** implements a cache on top of Hazelcast.
 *  <p>
 *  Every cache item has an unique ID.
 *  Every cache item can be from any type.
 *  Null as value for an item will be allowed.
 *  </p>
 *  <p>
 *  Internally we use one map for one cache item.
 *  Those map contain the value (of course) and some
 *  internal meta data.
 *  </p>
 *  <p>
 *  Don't use one map for all cache items ...
 *  that will be a performance bottle neck as it's best .-)
 *  </p>
 */
public class HazelcastCache implements ICache
{
	//-------------------------------------------------------------------------
	private static final Logger LOG = LoggerFactory.getLogger(HazelcastCache.class);

	//-------------------------------------------------------------------------
	public static final String ATTR_VALUE = "value";

	//-------------------------------------------------------------------------
	private HazelcastCache ()
	{}

	//-------------------------------------------------------------------------
	public static HazelcastCache create (final HazelcastInstance aImpl)
	    throws Exception
	{
		final HazelcastCache aCache = new HazelcastCache ();
		aCache.m_aImpl = aImpl;
		return aCache;
	}

	//-------------------------------------------------------------------------
	@Override
	public String newID ()
		throws Exception
	{
		final String sID = UUID.randomUUID().toString();
		return sID;
	}

	//-------------------------------------------------------------------------
	@Override
	public void setCacheItem (final String sID  ,
							  final String sItem)
		throws Exception
	{
		LOG.debug("set cache item ["+sID+":"+sItem+"]");
		Validate.notEmpty(sID, "Invalid argument 'id'.");

		final Map< String, String > aMap  = m_aImpl.getMap(sID);
		aMap.put(ATTR_VALUE, sItem);
	}

	//-------------------------------------------------------------------------
	@Override
	public String getCacheItem (final String sID)
		throws Exception
	{
		LOG.debug("get cache item ["+sID+"]");
		Validate.notEmpty(sID, "Invalid argument 'id'.");

		final Map< String, String > aMap  = m_aImpl.getMap(sID);
		final String                sItem = aMap.get(ATTR_VALUE);
		LOG.debug("... got item from cache ["+sID+":"+sItem+"]");

		return sItem;
	}

	//-------------------------------------------------------------------------
	private HazelcastInstance m_aImpl = null;
}
