package com.openexchange.office.tools.common;

import org.apache.commons.lang3.StringUtils;
import com.openexchange.office.tools.common.string.StringHelper;

public class DigestHelper {
    private static final int BYTES_FOR_SHA256 = 256 / 8;

    private DigestHelper() {
        // nothing to do
    }

    public static boolean isSHA256HexString(String sha256AsHex) {
        return (StringUtils.isNotEmpty(sha256AsHex) && 
                (sha256AsHex.length() == (BYTES_FOR_SHA256 * 2)) &&
                (StringHelper.isHexString(sha256AsHex)));
    }
}
