package com.openexchange.office.rt2.hazelcast.serialization;

import org.springframework.stereotype.Service;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Portable;
import com.openexchange.hazelcast.serialization.AbstractCustomPortableFactory;
import com.openexchange.office.tools.annotation.RegisteredService;

@Service
@RegisteredService
public class PortableSafeDecrementFunctorFactory extends AbstractCustomPortableFactory {

    @Override
    public Portable create() {
        return new PortableSafeDecrementFunctor();
    }

    @Override
    public int getClassId() {
        return PortableSafeDecrementFunctor.CLASS_ID;
    }

    @Override
    public ClassDefinition getClassDefinition() {
        return PortableSafeDecrementFunctor.CLASS_DEFINITION;
    }

}
