package com.openexchange.office.rt2.hazelcast.serialization;

import java.io.IOException;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.openexchange.hazelcast.serialization.CustomPortable;


public class PortableSafeDecrementFunctor implements CustomPortable, IFunction<Long, Long> {

    //-------------------------------------------------------------------------
    public static final int CLASS_ID = 214;

    private static final long serialVersionUID = -7833322817711705268L;

    private Long value = 1L;
    private static final String FIELD_VALUE = "value";

    //-------------------------------------------------------------------------
    public static ClassDefinition CLASS_DEFINITION = null;

    //-------------------------------------------------------------------------
    static {
        CLASS_DEFINITION = new ClassDefinitionBuilder(FACTORY_ID, CLASS_ID)
        .addLongField(FIELD_VALUE)
        .build();
    }

    //-------------------------------------------------------------------------
    public PortableSafeDecrementFunctor(long value) {
        this.value = value;
    }

    //-------------------------------------------------------------------------
    public PortableSafeDecrementFunctor() {
        super();
    }

    //-------------------------------------------------------------------------
    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeLong(FIELD_VALUE, value);
    }

    //-------------------------------------------------------------------------
    @Override
    public void readPortable(PortableReader reader) throws IOException {
        value = reader.readLong(FIELD_VALUE);
    }

    //-------------------------------------------------------------------------
    @Override
    public Long apply(Long input) {
        if ((input - value ) > 0)
            return input - value;
        else
            return 0L;
    }

    //-------------------------------------------------------------------------
    @Override
    public int getClassId() {
        return CLASS_ID;
    }

    //-------------------------------------------------------------------------
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

    //-------------------------------------------------------------------------
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof PortableSafeDecrementFunctor))
            return false;
        PortableSafeDecrementFunctor other = (PortableSafeDecrementFunctor) obj;
        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

}
