package com.openexchange.office.rt2.core.proxy;

import java.time.LocalDateTime;

import com.openexchange.office.rt2.core.RT2LogInfo;
import com.openexchange.office.rt2.protocol.RT2Message;
import com.openexchange.office.rt2.protocol.value.RT2CliendUidType;
import com.openexchange.office.rt2.protocol.value.RT2DocUidType;
import com.openexchange.office.rt2.protocol.value.RT2ErrorCodeType;
import com.openexchange.office.rt2.protocol.value.RT2SeqNumberType;
import com.openexchange.office.tools.common.error.ErrorCode;

public class RT2DocProxyLogInfo implements Comparable<RT2DocProxyLogInfo>, RT2LogInfo {
	
	public enum Direction {UNKNOWN, FROM_WS, FROM_JMS, INTERNAL};
	
	private final Direction direction;
	private final String msgType;
	private final RT2SeqNumberType seqNr;
	private final RT2CliendUidType clientUid;
	private final RT2DocUidType docUid;
	private final RT2ErrorCodeType errorCode;
	private final LocalDateTime occured;
	
	public RT2DocProxyLogInfo(Direction direction, String msgType, RT2CliendUidType clientUid, RT2DocUidType docUid) {
		this.direction = direction;
		this.msgType = msgType;
		seqNr = new RT2SeqNumberType(-1);
		this.clientUid = clientUid;
		this.docUid = docUid;
		this.errorCode = new RT2ErrorCodeType(ErrorCode.NO_ERROR);
		this.occured = LocalDateTime.now();
	}
	
	public RT2DocProxyLogInfo(Direction direction, RT2Message msg) {
		this.direction = direction;
		msgType = msg.getType().getValue();
		if (msg.isSequenceMessage()) {
			seqNr = msg.getSeqNumber();
		} else {
			seqNr = new RT2SeqNumberType(-1);
		}
		clientUid = msg.getClientUID();
		docUid = msg.getDocUID();
		if (msg.isError()) {
			errorCode = msg.getError();
		} else {
			errorCode = new RT2ErrorCodeType(ErrorCode.NO_ERROR);
		}
		this.occured = LocalDateTime.now();
	}

	@Override	
	public RT2CliendUidType getClientUid() {
		return clientUid;
	}

	@Override
	public RT2DocUidType getDocUid() {
		return null;
	}
	
	@Override
	public int compareTo(RT2DocProxyLogInfo o) {
		return this.occured.compareTo(o.occured);
	}

	@Override
	public String toString() {
		return "RT2DocProxyLogInfo [direction=" + direction + ", msgType=" + msgType + ", seqNr=" + seqNr
				+ ", clientUid=" + clientUid + ", docUid=" + docUid + ", errorCode=" + errorCode + ", occured="
				+ occured + "]";
	}

	@Override
	public boolean isDocProcessorLogInfo() {
		return false;
	}
}
