/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.rt2.core.proxy;

import java.util.HashMap;
import java.util.Map;

import com.openexchange.office.rt2.core.exception.RT2Exception;

//=============================================================================
public class Deferred< T >
{
    //-------------------------------------------------------------------------
    public static interface Base< T >
    {
    	public void done (final T aData) throws RT2Exception;

    	public void fail (final T aData) throws RT2Exception;

    	public void always (final T aData) throws RT2Exception;
    }

    //-------------------------------------------------------------------------
    public static abstract class Func< T > implements Base< T >
    {
        @Override
    	public void done (final T aData) throws RT2Exception
    	{}

        @Override
    	public void fail (final T aData) throws RT2Exception
    	{}

        @Override 
    	public void always (final T aData) throws RT2Exception
    	{}
    }

    //-------------------------------------------------------------------------
    public Deferred ()
    { /* nothing to do*/ }

    //-------------------------------------------------------------------------
    public synchronized < V > void setMetaData(final String sKey  ,
    									       final V      aValue)
    {
    	mem_MetaData ().put(sKey, aValue);
    }

    //-------------------------------------------------------------------------
    public synchronized void setMetaData(final Map< String, Object > lMetaData)
    {
    	mem_MetaData ().putAll(lMetaData);
    }

    //-------------------------------------------------------------------------
    public synchronized Map< String, Object > getMetaData()
    {
    	return mem_MetaData ();
    }

    //-------------------------------------------------------------------------
    @SuppressWarnings("unchecked")
    public synchronized < V > V getMetaDataValue(final String sKey)
    {
    	return (V) mem_MetaData ().get(sKey);
    }

    //-------------------------------------------------------------------------
    public /* no synchronized */ void resolve (final T aData) throws RT2Exception
    {
        Base< T > aDone   = null;
        Base< T > aAlways = null;

        synchronized(this)
        {
            aDone   = m_aDone  ;
            aAlways = m_aAlways;
        }

    	if (aDone != null)
    		aDone.done (aData);

    	if (aAlways != null)
    	   aAlways.always (aData);

    	impl_doAutoCloseIfEnabled ();
    }

    //-------------------------------------------------------------------------
    public /* no synchronized */ void reject (final T aData) throws RT2Exception
    {
        Base< T > aFail   = null;
        Base< T > aAlways = null;

        synchronized(this)
        {
            aFail   = m_aFail  ;
            aAlways = m_aAlways;
        }

        if (aFail != null)
    		aFail.fail (aData);

        if (aAlways != null)
            aAlways.always (aData);

        impl_doAutoCloseIfEnabled ();
    }

    //-------------------------------------------------------------------------
    public synchronized Deferred< T > setAutoClose (final boolean bAutoClose)
    {
        m_bAutoClose = bAutoClose;
        return this;
    }

    //-------------------------------------------------------------------------
    public synchronized Deferred< T > done(final Base< T > aFunc)
    {
    	m_aDone = aFunc;
    	return this;
    }

    //-------------------------------------------------------------------------
    public synchronized Deferred< T > fail(final Base< T > aFunc)
    {
    	m_aFail = aFunc;
    	return this;
    }

    //-------------------------------------------------------------------------
    public synchronized Deferred< T > always(final Base< T > aFunc)
    {
        m_aAlways = aFunc;
        return this;
    }

    //-------------------------------------------------------------------------
    public synchronized void close ()
    {
        m_bClosed = true;
    }

    //-------------------------------------------------------------------------
    public synchronized boolean isClosed ()
    {
        return m_bClosed;
    }

    //-------------------------------------------------------------------------
    private /* no synchronized */ void impl_doAutoCloseIfEnabled ()
    {
        boolean bClose = false;

        synchronized (this)
        {
            bClose = m_bAutoClose;
        }

        if (bClose)
            close ();
    }

    //-------------------------------------------------------------------------
    private Map< String, Object > mem_MetaData ()
    {
    	if (m_lMetaData == null)
    		m_lMetaData = new HashMap<> ();
    	return m_lMetaData;
    }

    //-------------------------------------------------------------------------
    private Base< T > m_aDone = null;

    //-------------------------------------------------------------------------
    private Base< T > m_aFail = null;

    //-------------------------------------------------------------------------
    private Base< T > m_aAlways = null;

    //-------------------------------------------------------------------------
    private Map< String, Object > m_lMetaData = null;

    //-------------------------------------------------------------------------
    private boolean m_bAutoClose = true;

    //-------------------------------------------------------------------------
    private boolean m_bClosed = false;

}
