package com.openexchange.office.rt2.core.doc;

import java.util.concurrent.CopyOnWriteArraySet;

import org.springframework.stereotype.Service;

import com.openexchange.office.rt2.protocol.value.RT2DocUidType;

@Service
public class DocProcessorEventService {
	
	private CopyOnWriteArraySet<IDocProcessorEventListener> listeners = new CopyOnWriteArraySet<>();
	
	public void addListener(IDocProcessorEventListener listener) {
		listeners.add(listener);
	}
	
	public void removeListener(IDocProcessorEventListener listener) {
		listeners.remove(listener);
	}
	
	public void notifyDocCreated(RT2DocUidType docUid) {
		listeners.forEach(l -> l.docCreated(docUid));
	}
	
	public void notifyDocDisposed(RT2DocUidType docUid) {
		listeners.forEach(l -> l.docDisposed(docUid));
	}
}
