package com.openexchange.office.rt2.core.doc;

import java.util.concurrent.CopyOnWriteArraySet;

import org.springframework.stereotype.Service;

import com.openexchange.office.rt2.protocol.RT2Message;
import com.openexchange.office.rt2.protocol.value.RT2MessageType;

@Service
public class ClientEventService {
	
	private CopyOnWriteArraySet<IClientEventListener> listeners = new CopyOnWriteArraySet<>();
	
	public void addListener(IClientEventListener listener) {
		listeners.add(listener);
	}
	
	public void removeListener(IClientEventListener listener) {
		listeners.remove(listener);
	}
	
	public void notifyClientAdded(RT2Message msg) {
		if (RT2MessageType.REQUEST_JOIN.equals(msg.getType())) {
			listeners.forEach(l -> l.clientAdded(new ClientEventData(msg.getDocUID(),  msg.getClientUID())));
		}
	}
	
	public void notifyClientRemoved(ClientEventData clientEventData) {
		listeners.forEach(l -> l.clientRemoved(clientEventData));
	}
}
