/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.rt2.core.config;

//=============================================================================
public class RT2Const
{
    //-------------------------------------------------------------------------
    // max number of users that collaborate on one document
    public static final int    RT2_MAX_COUNT_COLLABORATION_USERS = 200;

    //-------------------------------------------------------------------------
    // version number of the RT2 REST API (will be part of the URL schema ...)
    public static final int    RT2_VERSION = 1;

    //-------------------------------------------------------------------------
    // the URL root for our REST API
    public static final String RT2_URL_BASE = "/rt2";

    //-------------------------------------------------------------------------
    // the URL pattern where our REST API will be registered for
    public static final String RT2_URL_PATTERN = RT2Const.RT2_URL_BASE+"/v"+RT2_VERSION+"/*";

    //-------------------------------------------------------------------------
    // the ID of the JMS Connection bean within our Camel Routing Context
    public static final String BEANID_JMS_CONNECTION = "jms";

    //-------------------------------------------------------------------------
    public static final String DOCTYPE_TEXT         = "text"        ;
    public static final String DOCTYPE_SPREADSHEET  = "spreadsheet" ;
    public static final String DOCTYPE_PRESENTATION = "presentation";
    public static final String DOCTYPE_PRESENTER    = "presenter"   ;

    //-------------------------------------------------------------------------
    public static final int     DEFAULT_PORT_JMS                  = 61616;

    public static final String  DEFAULT_MONITOR_HOST              = "localhost";
    public static final int     DEFAULT_MONITOR_PORT              = 9876;

    public static final long    DEFAULT_GC_FREQUENCY_IN_MS        = 300000 ; // 5 min
    public static final long    DEFAULT_GC_OFFLINE_TRESHOLD_IN_MS = 1800000; // 30 min
    public static final long    DEFAULT_KEEPALIVE_FREQUENCY_IN_MS = 10000  ; // 10 sec
    public static final boolean DEFAULT_BACKGROUND_SAVE_DOC       = true;
    public static final long    DEFAULT_TIMEOUT_4_SEND_IN_MS      = 60000  ; // 1 min
    public static final int 	DEFAULT_MAX_SESSIONS_PER_NODE     = 50;
}
