/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rest.operations;

import com.openexchange.office.datasource.access.DataSourceResourceAccess;
import com.openexchange.office.datasource.access.MetaData;
import com.openexchange.office.rest.job.Job;
import com.openexchange.tools.session.ServerSession;

public class GetOperationsJob extends Job {

    private final ServerSession session;
    private final DataSourceResourceAccess docAccess;
    private final DocumentOperationService documentOperationService;
    private final OperationDataCache operationDataCache;

    // ---------------------------------------------------------------
    public GetOperationsJob(ServerSession session, DataSourceResourceAccess docAccess, DocumentOperationService documentOperationService, OperationDataCache operationDataCache) {
        this.session = session;
        this.docAccess = docAccess;
        this.documentOperationService = documentOperationService;
        this.operationDataCache = operationDataCache;
    }

    // ---------------------------------------------------------------
    @Override
    public boolean execute() throws Exception {
    	final MetaData metaData = docAccess.getMetaData();
        final String hash = metaData.getHash();
        final OperationsResult aResult = documentOperationService.getOperationsFromDataSourceAccess(docAccess, session);

        if (aResult.getErrorCode().isNoError()) {
            final String aEntryKey = OperationDataCache.createKey(docAccess.getFolder(), docAccess.getId(), docAccess.getVersionOrAttachmentId(), docAccess.getContextId());
            final OperationData aData = new OperationData(aEntryKey, hash, aResult.getHtmlDoc(), aResult.getPreviewData(), aResult.getOperations());

            operationDataCache.put(aEntryKey, aData);
        }
        return aResult.getErrorCode().isNoError();
    }
}
