/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rest.operations;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

import com.openexchange.office.tools.doc.DocumentFormat;
import com.openexchange.office.tools.doc.DocumentFormatHelper;

public class DocumentContentAccess {
	private final byte[] contentData;
	private final String fileName;
	private final String mimeType;
	private final int size;
	private String hash = null;
	private String key;
	private DocumentFormat docFormat = DocumentFormat.NONE;

	public DocumentContentAccess(byte[] contentData, String fileName, String mimeType) {
		this.contentData = contentData;
		this.fileName = fileName;
		this.mimeType = mimeType;
		size = contentData.length;
	}

	public DocumentContentAccess(byte[] contentData, String fileName, String mimeType, String hash) {
		this.contentData = contentData;
		this.fileName = fileName;
		this.mimeType = mimeType;
		this.hash = hash;
		size = contentData.length;
		docFormat = mapMimeTypeToDocumentFormat(mimeType);
	}

	public ByteArrayInputStream getStream() {
		return new ByteArrayInputStream(contentData);
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}

	public String getHash() throws NoSuchAlgorithmException {
		if (hash == null) {
			hash = MessageDigest.getInstance("SHA-256").digest(contentData).toString();
		}
		return hash;
	}

    public String getFileName() {
    	return fileName;
    }

    public String getMimeType() {
    	return mimeType;
    }

    public int getSize() {
    	return size;
    }

    public DocumentFormat getDocFormat() {
    	return docFormat;
    }

    private DocumentFormat mapMimeTypeToDocumentFormat(String mimeType) {
    	DocumentFormat result = DocumentFormat.NONE;

    	final Map<String, String> docFormatInfo = DocumentFormatHelper.getFormatInfoForMimeTypeOrExtension(mimeType, "");
    	if (docFormatInfo != null) {
    		docFormat = DocumentFormat.valueOf(docFormatInfo.get("DocumentType"));
    	}

    	return result;
    }

}
