package com.openexchange.office.rest.mention;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.office.rest.mention.to.CommentNotificationRecipientTO;
import com.openexchange.office.rest.mention.to.CommentNotificationRequestDataTO;
import com.openexchange.office.tools.service.files.FileHelperService;
import com.openexchange.office.tools.service.files.FileHelperServiceFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.user.User;
import com.openexchange.user.UserService;

@Service
public class CommentNotificationRequestDataTOToCommentNotificationRequestDataConverter {
	
	@Autowired
	private FileHelperServiceFactory fileHelperServiceFactory;

	@Autowired
	private UserService userService;
	
	@Autowired
	private ContextService contextService;
	
	public CommentNotificationRequestData convert(Session session, CommentNotificationRequestDataTO to) throws OXException {
		
		FileHelperService fileHelperService = fileHelperServiceFactory.create(session);
		com.openexchange.file.storage.File fileMetadata = fileHelperService.getFileMetaData(to.getFileId());
		
		// User do not override equals and hashcode!!! 
		Map<UserAdapter, List<CommentNotificationRecipientPositionInComment>> userMap = new HashMap<>();
		List<CommentNotificationRecipient> recipients = new ArrayList<>();
				
		Context context = contextService.getContext(session.getContextId());
		
		for (CommentNotificationRecipientTO recipientTO : to.getRecipients()) {
			User user = null;
			if ((recipientTO.getUserId() != null) && (recipientTO.getUserId() > 0)) {
				user = userService.getUser(recipientTO.getUserId(), session.getContextId());
			} else {
				if (recipientTO.getEmailAddress() != null) {
					user = userService.searchUser(recipientTO.getEmailAddress(), context, true, true, false);
				} 			
			}
			if (user != null) {
				UserAdapter userAdapter = new UserAdapter(user);
				if (!userMap.containsKey(userAdapter)) {
					userMap.put(userAdapter, new ArrayList<>());
				} 
				userMap.get(userAdapter).add(new CommentNotificationRecipientPositionInComment(user, recipientTO.getPosInComment(), recipientTO.getLengthInComment()));
			} else {
				throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("userId", recipientTO.getUserId(), "email", recipientTO.getEmailAddress());
			}	 			
		}
		userMap.forEach((k,v) -> {
			recipients.add(new CommentNotificationRecipient(k.getUser(), v));
		});
		CommentNotificationRequestData res = new CommentNotificationRequestData(recipients, to.getComment(), to.getCommentId(), fileMetadata);
		return res;
	}
	
	private class UserAdapter {
		private final User user;
		
		public UserAdapter(User user) {		
			this.user = user;
		}
		
		public User getUser() {
			return user;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + new Integer(user.getId()).hashCode();
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			UserAdapter other = (UserAdapter) obj;
			if (user == null) {
				if (other.user != null)
					return false;
			} else if (user.getId() != other.getUser().getId())
				return false;
			return true;
		}
	}
}
