package com.openexchange.office.rest.mention;

import java.util.Collections;
import java.util.List;

import com.openexchange.file.storage.File;

public class CommentNotificationRequestData {

	private final List<CommentNotificationRecipient> recipients;
	
	private final String comment;
	
	private final String commentId;

	private final File fileMetadata;

	public CommentNotificationRequestData(List<CommentNotificationRecipient> recipients, String comment, String commentId, File fileMetadata) {
		this.recipients = Collections.unmodifiableList(recipients);
		this.comment = comment;
		this.commentId = commentId;
		this.fileMetadata = fileMetadata;
	}

	public String getComment() {
		return comment;
	}

	public String getCommentId() {
		return commentId;
	}

	public List<CommentNotificationRecipient> getRecipients() {
		return recipients;
	}

	public File getFileMetadata() {
		return fileMetadata;
	}
}
