package com.openexchange.office.rest.mention;

import com.google.common.io.BaseEncoding;

class CommentNotificationFileTypeImage {

    private final String contentType;

    private final byte[] data;

    private String cid;

    CommentNotificationFileTypeImage(String contentType, byte[] data) {
        this.contentType = contentType;
        this.data = data;
    }

    /**
     * Gets the content type, e.g. <code>image/png</code>
     *
     * @return The content type
     */
    public String getContentType() {
        return contentType;
    }

    /**
     * Gets the content id that has been set as the <code>src</code> attributes
     * value.
     *
     * @return The plain content id without any cid-prefix, brackets or applied encoding.
     */
    public String getContentId() {
        return cid;
    }

    /**
     * Gets the image data as byte array
     *
     * @return The data
     */
    public byte[] getData() {
        return data;
    }

    /**
     * Gets the image data as base64 encoded string
     *
     * @return The data
     */
    public String getB64Data() {
        return BaseEncoding.base64().encode(data);
    }

    void setContentId(String cid) {
        this.cid = cid;
    }
}
