/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.rest;

import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.office.recentfilelist.RecentFileListManager;
import com.openexchange.office.recentfilelist.RecentFileListManagerFactory;
import com.openexchange.office.rest.tools.ParamValidatorService;
import com.openexchange.office.rest.tools.SessionIdCheck;
import com.openexchange.office.tools.common.error.HttpStatusCode;
import com.openexchange.office.tools.doc.ApplicationType;
import com.openexchange.office.tools.service.files.FolderHelperService;
import com.openexchange.office.tools.service.files.FolderHelperServiceFactory;
import com.openexchange.tools.session.ServerSession;

@RestController
public class DeleteFileFromRecentListAction extends DocumentRESTAction {
	private static final Logger LOG = LoggerFactory.getLogger(DeleteFileFromRecentListAction.class);
    private static final String[] MANDATORY_PARAMS = { ParameterDefinitions.PARAM_TYPE, ParameterDefinitions.PARAM_REMOVE_FILE_ID };

    @Autowired
    private FolderHelperServiceFactory folderHelperServiceFactory;
    
    @Autowired
    private RecentFileListManagerFactory recentFileListManagerFactory;
    
    
    
    @Override
	public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        if (!paramValidatorService.areAllParamsNonEmpty(requestData, MANDATORY_PARAMS))
            return ParamValidatorService.getResultFor(HttpStatusCode.BAD_REQUEST.getStatusCode());

        final String type = requestData.getParameter(ParameterDefinitions.PARAM_TYPE).toLowerCase();
    	final ApplicationType appType = ApplicationType.stringToEnum(type);
        AJAXRequestResult requestResult = null;

        if ((null != session) && (appType != ApplicationType.APP_NONE)) {
            // #60801: we need to check for an illegal CSRF attempt by checking the
            // correct sessionId; set errorcode to 400 in case of an invalid request
            if (SessionIdCheck.isNotValid(requestData.getParameter("session"), session)) {
                LOG.warn("DeleteFileFromRecentListAction detected invalid session id - request rejected!");
                return ParamValidatorService.getResultFor(HttpStatusCode.BAD_REQUEST.getStatusCode());
            }

            try {
            	final FolderHelperService folderHelperService = folderHelperServiceFactory.create(session);
                final String removeFileId = requestData.getParameter(ParameterDefinitions.PARAM_REMOVE_FILE_ID);
            	final JSONObject remove = new JSONObject();
            	remove.put("folder_id", folderHelperService.getFolderId(removeFileId));
            	remove.put("id", removeFileId);

                final RecentFileListManager recentFileListManager = recentFileListManagerFactory.create(session);
                final List<JSONObject> appRecentFiles = recentFileListManager.readRecentFileList(appType);
                if ((null != appRecentFiles) && (!appRecentFiles.isEmpty())) {
                    boolean changed = recentFileListManager.removeFileFromList(appRecentFiles, remove);
                    if (changed) {
                        recentFileListManager.writeRecentFileList(appType, appRecentFiles);
                        recentFileListManager.flush();
                    }
                }
            } catch (JSONException e) {
                LOG.error("Exception while creating JSONObject answering AJAXRequest in 'DeleteFileFromRecentListAction'", e);
            }
            requestResult = new AJAXRequestResult();
        }

        return requestResult;
	}

}
