/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

public abstract class NodeHolder
        implements
        INode
{

    private final List<INode> children = new ArrayList<INode>();
    private JSONObject        attrs;

    private static final Paragraph IMPLICITPARA      = new Paragraph();
    static
    {
        IMPLICITPARA.setImplicit(true);
    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject attrs)
        throws Exception
    {
        if (start.length() == 0)
        {
            this.attrs = attrs;
            return true;
        }
        else
        {
            final int childIndex = start.getInt(0);
            final INode child = children.get(childIndex);
            final JSONArray subStart = GenDocHelper.shiftedCopy(start);
            final JSONArray subEnd = GenDocHelper.shiftedCopy(end);
            return child.setAttribute(subStart, subEnd, attrs);
        }

    }

    @Override
    public JSONObject getAttribute()
    {
        return attrs;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        boolean appendedContent = false;
        if (children.size() > 0) {
	        for (final INode child : children) {
	            appendedContent |= child.appendContent(document);
	        }

	        // check type of last child and append implicit
	        // paragraph if necessary (behind table).
	        INode lastChild = children.get(children.size()-1);
        	if (lastChild instanceof Table) {
                IMPLICITPARA.appendContent(document);
        	}
        }
        return appendedContent;
    }

    @Override
    public void insert(
        JSONArray start,
        INode newChild)
        throws Exception
    {
        if (start.length() == 1)
        {
            if (newChild instanceof SubNode)
            {
                throw new Exception("subnode are only allowed under Pragraphs! myClass: " + getClass().getSimpleName() + " childClass: " + newChild.getClass().getSimpleName() + " " + start);
            }
            final int childIndex = start.getInt(0);
            children.add(childIndex, newChild);
        }
        else
        {
            final int childIndex = start.getInt(0);
            final INode child = children.get(childIndex);
            final JSONArray subStart = GenDocHelper.shiftedCopy(start);
            child.insert(subStart, newChild);
        }
    }

    protected int getChildrenCount()
    {
        return children.size();
    }

    protected List<INode> getChildren()
    {
        return children;
    }

    @Override
    public int getTextLength()
    {
        int res = 0;
        for (INode sn : children)
        {
            res += sn.getTextLength();
        }
        return res;
    }

    @Override
    public String toString()
    {
        return this.getClass().getSimpleName() + " " + children;
    }

}
