/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNode
        extends NodeHolder
{
    private final static Logger LOG                = LoggerFactory.getLogger(DocumentNode.class);
    private final static String IMPLICIT_PARAGRAPH = Paragraph.PARASTART + "jquerydata=\"{&quot;implicit&quot;:true}\" >" + Paragraph.EMPTYSPAN + "</div>";

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        List<INode> children = getChildren();
        final int count = getChildrenCount();
        boolean mustSetSplitpoint = false;

        int paraCount = 0;
        int textLength = 0;
        int i = 0;
        for (; i < count; i++)
        {
            INode child = children.get(i);
            textLength += child.getTextLength();

            // Bug 35671
            // Formatting of tables is done asynchronously, therefore we
            // don't want to have a splitpoint at all, if we find a table.
            if (child instanceof Table) {
                break;
            }

            paraCount += determineParagraphCount(child);
            if ((textLength > 2000) && (paraCount > 25))
                mustSetSplitpoint = true;

            if (mustSetSplitpoint && (child instanceof ISplitpoint))
            {
                ((ISplitpoint) child).setSplitpoint(true);
                LOG.debug("set splitpoint on " + i + " of " + count + " elements");
                break;
            }

            child.appendContent(document);
        }

        for (; i < count; i++)
        {
            INode child = children.get(i);
            child.appendContent(document);
        }

        if (count == 0 || getChildren().get(count - 1) instanceof Table)
        {
            // implicit Paragraph
            document.append(IMPLICIT_PARAGRAPH);
        }

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    private int determineParagraphCount(
        final INode node)
    {
        int result = 0;

        if (node instanceof Paragraph)
            return 1;
        else if (node instanceof Table)
        {
            final Table table = (Table) node;
            return table.getRowCount();
        }

        return result;
    }
}
