/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import com.openexchange.file.storage.File;

public class DocMetaData {

    private final String folder_id;
    private final String id;
    private final String versionOrAttachment;
    private final long fileSize;
    private final String fileName;
    private String mimeType;
    private String source = "drive";

    public DocMetaData(File fileMetaData) {
        this.folder_id = fileMetaData.getFolderId();
        this.id = fileMetaData.getId();
        this.versionOrAttachment = fileMetaData.getVersion();
        this.fileSize = fileMetaData.getFileSize();
        this.fileName = fileMetaData.getFileName();
        this.mimeType = fileMetaData.getFileMIMEType();
        this.source = "drive";
    }

    public DocMetaData(String folderId, String id, String versionOrAttachment, long fileSize, String fileName, String source) {
        this.folder_id = folderId;
        this.id = id;
        this.versionOrAttachment = versionOrAttachment;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.mimeType = "";
        this.source = source;
    }

    public DocMetaData(String folderId, String id, String versionOrAttachment, long fileSize, String fileName, String source, String mimeType) {
        this(folderId, id, versionOrAttachment, fileSize, fileName, source);
        this.mimeType = mimeType;
    }

    public String getFolderId() {
        return folder_id;
    }

    public String getId() {
        return id;
    }

    public String getVersionOrAttachment() {
        return versionOrAttachment;
    }

    public long getFileSize() {
        return fileSize;
    }

    public String getFileName() {
        return fileName;
    }

    public String getMimeType() {
        return mimeType;
    }

    public String getSource() {
        return source;
    }

}
