/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import java.util.List;

public class Cell
        extends NodeHolder
{

    private final static Paragraph EXPLICITPARA = new Paragraph();
    static
    {
    	EXPLICITPARA.setInTable(true);
    }

    public Cell()
            throws Exception
    {
        this(false);
    }

    public Cell(boolean insertExplicitParagraph)
        throws Exception
    {
        super();
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        document.append("<td");
        GenDocHelper.appendAttributes(getAttribute(), document);
        document.append(" role='gridcell' colspan='1' style='border: 1px solid rgb(0, 0, 0); padding: 2px 7px; background-color: transparent;'>");
        document.append("<div class='cell' contenteditable='false'>");
        document.append("<div class='resize bottom'></div>");
        document.append("<div class='resize right'></div>");
        document.append("<div class='cellcontent' contenteditable='true' data-focus-role='cell'>");

        List<INode> children = getChildren();
        int childCount = children.size();

        if (childCount > 0)
        {
            // There must be a implicit paragraph at the end, if the content of
            // the table cell doesn't have any paragraph. So we have to check
            // our children. See #35498
        	boolean hasParagraph = false;

        	for (int i = 0; i < childCount; i++) {
        	    final INode child = children.get(i);

                if (child instanceof Paragraph) {
                    hasParagraph = true;
                }
            }
            super.appendContent(document);

            // if needed, create implicit paragraph
            if (!hasParagraph)
            {
            	EXPLICITPARA.appendContent(document);
            }
        }
        else
        {
        	EXPLICITPARA.appendContent(document);
        }

        document.append("</div>");
        document.append("</div>");
        document.append("</td>");
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }
}