/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.tools;

import org.docx4j.dml.BaseStyles;
import org.docx4j.dml.BaseStyles.FontScheme;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.dml.FontCollection;
import org.docx4j.dml.TextFont;
import org.docx4j.dml.Theme;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.STTheme;


public class ThemeFonts {

    private String minorFont = "Calibri";
    private String majorFont = "Cambria";

    /**
     * The internal identifier of the major theme font (headings) used in OOXML.
     */
    public static final String MAJOR_ID = "+mj-lt";

    /**
     * The internal identifier of the minor theme font (body text) used in OOXML.
     */
    public static final String MINOR_ID = "+mn-lt";

    public ThemeFonts(ThemePart themePart) {
        if(themePart!=null) {
        	final Theme theme = themePart.getJaxbElement();
        	if(theme!=null) {
	            BaseStyles themeElements = theme.getThemeElements();
	            if(themeElements!=null) {
	                FontScheme fontScheme = themeElements.getFontScheme();
	                if(fontScheme!=null) {
	                    FontCollection minorFontCollection = fontScheme.getMinorFont();
	                    if(minorFontCollection!=null) {
	                        TextFont minorTextFont = minorFontCollection.getLatin();
	                        if(minorTextFont!=null)
	                            minorFont = minorTextFont.getTypeface();
	                    }
	                    FontCollection majorFontCollection = fontScheme.getMajorFont();
	                    if(majorFontCollection!=null) {
	                        TextFont majorTextFont = majorFontCollection.getLatin();
	                        if(majorTextFont!=null)
	                            majorFont = majorTextFont.getTypeface();
	                    }
	                }
	            }
        	}
        }
    }

    public String getMinorFont() {
        return minorFont;
    }

    public String getMajorFont() {
        return majorFont;
    }

    private String getTheme(STTheme theme) {
        String font = null;
        if(theme==STTheme.MAJOR_H_ANSI)
            font = getMajorFont();
        else if(theme==STTheme.MINOR_H_ANSI)
            font = getMinorFont();
        else if(theme==STTheme.MAJOR_ASCII)
            font = getMajorFont();
        else if(theme==STTheme.MINOR_ASCII)
            font = getMinorFont();
        return font;
    }

    public String getFont(RFonts rFonts) {
        String font = null;
        if(rFonts!=null) {
            // first we have to try themes...
            font = getTheme(rFonts.getHAnsiTheme());
            if(font==null)
                font = getTheme(rFonts.getAsciiTheme());

            // no theme found...
            if(font==null)
                font = rFonts.getHAnsi();
            if(font==null||font.length()==0)
                font = rFonts.getAscii();
        }
        return font;
    }

    public RFonts setFont(String fontName) {
        final RFonts rFonts = new RFonts();
        if(MINOR_ID.equals(fontName)) {
            rFonts.setAsciiTheme(STTheme.MINOR_H_ANSI);
            rFonts.setHAnsiTheme(STTheme.MINOR_H_ANSI);
        }
        else if(MAJOR_ID.equals(fontName)) {
            rFonts.setAsciiTheme(STTheme.MAJOR_H_ANSI);
            rFonts.setHAnsiTheme(STTheme.MAJOR_H_ANSI);
        }
        else {
            rFonts.setAscii(fontName);
            rFonts.setHAnsi(fontName);
            rFonts.setCs(fontName);
            rFonts.setEastAsia(fontName);
        }
        return rFonts;
    }
}
