/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.xlsx;

import java.io.InputStream;

import org.springframework.stereotype.Service;
import org.xlsx4j.jaxb.Context;

import com.openexchange.office.filter.api.DocumentProperties;
import com.openexchange.office.filter.api.IExporter;
import com.openexchange.office.filter.ooxml.OfficeOpenXMLOperationDocument;
import com.openexchange.office.imagemgr.IResourceManager;
import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.common.osgi.context.OsgiBundleContextAndActivator;
import com.openexchange.office.tools.common.osgi.context.OsgiBundleContextAware;
import com.openexchange.session.Session;

/**
 * {@link Exporter}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
@Service
@RegisteredService
public class Exporter implements IExporter, OsgiBundleContextAware {

	private OsgiBundleContextAndActivator bundleCtx;
	
    /**
     * Initializes a new {@link Exporter}.
     */
    public Exporter() {
        Context.getsmlObjectFactory();
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.office.IExporter#createDocument(java.io.InputStream, org.json.JSONObject)
     */
    @Override
    public InputStream createDocument(Session session, InputStream documentStm, String applyOperations, IResourceManager resourceManager, DocumentProperties documentProperties, boolean createFinalDocument) {
        InputStream document = null;
        try(XlsxOperationDocument operationDocument = new XlsxOperationDocument(session, resourceManager, documentProperties)) {
        	bundleCtx.prepareObject(operationDocument);
            operationDocument.loadDocument(documentStm, false);
            operationDocument.setCreateFinalDocument(createFinalDocument);
            operationDocument.updateDocumentProperties();
            operationDocument.applyOperations(applyOperations);
            document = operationDocument.debugSave(applyOperations);
        }
        catch(Throwable e) {
            OfficeOpenXMLOperationDocument.rethrowFilterException(e, null);
        }
        return document;
    }
    
	@Override
	public void setApplicationContext(OsgiBundleContextAndActivator bundleCtx) {
		this.bundleCtx = bundleCtx;
	}
}
