/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.properties;

import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Namespaces;

final public class NumberNumber extends StyleNumberPropertiesBase {

    public NumberNumber(AttributesImpl attributesImpl) {
        super(attributesImpl);
    }

    @Override
    public String getQName() {
        return "number:number";
    }

    @Override
    public String getLocalName() {
        return "number";
    }

    @Override
    public String getNamespace() {
        return Namespaces.NUMBER;
    }

    public String getNumberFormat() {
        String result = "";

        final int minInt = getInteger("number:min-integer-digits", 0);
        Integer decimalPos = attributes.getIntValue("number:decimal-places");
        String decimalReplacement = getAttribute("number:decimal-replacement");
        Boolean isGroup = getBoolean("number:grouping", null);
        int i;

        if(minInt==1&&decimalPos==null&&decimalReplacement==null&&isGroup==null) {
            return "general";
        }
        if(decimalPos==null) {
            decimalPos = Integer.valueOf(0);
        }
        if(isGroup==null) {
            isGroup = Boolean.valueOf(false);
        }
        if( minInt == 0){
            result = "#";
        }
        for (i = 0; i < minInt; i++) {
            if (((i + 1) % 3) == 0 && isGroup) {
                result = ",0" + result;
            } else {
                result = "0" + result;
            }
        }
        while (isGroup && (result.indexOf(',') == -1)) {
            if (((i + 1) % 3) == 0 && isGroup) {
                result = "#,#" + result;
            } else {
                result = "#" + result;
            }
            i++;
        }

        if(decimalReplacement != null){
            result += '.' + decimalReplacement;
        } else if (decimalPos > 0) {
            result += ".";
            for (i = 0; i < decimalPos; i++) {
                result += "0";
            }
        }
        return result;
    }

    @Override
    public NumberNumber clone() {
        return (NumberNumber)_clone();
    }
}
