/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.odt.dom;

import java.util.Set;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import com.google.common.collect.ImmutableSet;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class TextField implements IElementWriter {

	static final public Set<String> TYPES = ImmutableSet.<String>builder()
		.add("author-initials")
		.add("author-name")
		.add("bookmark-ref")
		.add("chapter")
		.add("character-count")
		.add("conditional-text")
		.add("creation-date")
		.add("creation-time")
		.add("creator")
		.add("database-display")
		.add("database-name")
		.add("database-row-number")
		.add("database-row-select")
		.add("date")
		.add("dde-connection")
		.add("description")
		.add("editing-cycles")
		.add("editing-duration")
		.add("execute-macro")
		.add("expression")
		.add("file-name")
		.add("hidden-paragraph")
		.add("hidden-text")
		.add("image-count")
		.add("initial-creator")
		.add("keywords")
		.add("measure")
		.add("meta-field")
		.add("modification-date")
		.add("modification-time")
		.add("note-ref")
		.add("object-count")
		.add("page-continuation")
		.add("page-count")
		.add("page-number")
		.add("page-variable-get")
		.add("page-variable-set")
		.add("paragraph-count")
		.add("placeholder")
		.add("print-date")
		.add("print-time")
		.add("printed-by")
		.add("reference-ref")
		.add("script")
		.add("sender-city")
		.add("sender-company")
		.add("sender-country")
		.add("sender-email")
		.add("sender-fax")
		.add("sender-firstname")
		.add("sender-initials")
		.add("sender-lastname")
		.add("sender-phone-private")
		.add("sender-phone-work")
		.add("sender-position")
		.add("sender-postal-code")
		.add("sender-state-or-province")
		.add("sender-street")
		.add("sender-title")
		.add("sequence-ref")
		.add("sequence")
		.add("sheet-name")
		.add("subject")
		.add("table-count")
		.add("template-name")
		.add("text-input")
		.add("time")
		.add("title")
		.add("user-defined")
		.add("user-field-get")
		.add("user-field-input")
		.add("variable-get")
		.add("variable-input")
		.add("variable-set")
		.add("word-count")
		.add("footer")
		.add("header")
		.add("date-time")
		.build();

	private final AttributesImpl attributes;
	private String namespace;
	private String qName;
	private String localName;
	private String representation;

	public TextField(String namespace, String qName, String localName, Attributes attributes) {
	    this.namespace = namespace;
	    this.qName = qName;
		this.localName = localName;
		this.attributes = new AttributesImpl(attributes);

		representation = "";
	}

	public TextField() {
		this.attributes = new AttributesImpl();
		this.namespace = Namespaces.TEXT;
		this.qName = "text:user-defined";
		this.localName = "user-defined";
		this.representation = "";
	}

	public void setType(String type) {
		localName = type;
		if(type.equals("header")||type.equals("footer")||type.equals("date-time")) {
		    qName = "presentation:" + type;
		    namespace = Namespaces.PRESENTATION;
		}
		else {
		    qName = "text:" + type;
		    namespace = Namespaces.TEXT;
		}
	}

	public String getType() {
		return localName;
	}

	public void setRepresentation(String representation) {
		this.representation = representation;
	}

	public String getRepresentation() {
		return representation;
	}

	public AttributesImpl getAttributes() {
		return attributes;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, namespace, localName, qName);
		attributes.write(output);
		output.characters(representation);
		SaxContextHandler.endElement(output, namespace, localName, qName);
	}
}
