/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.odt.dom;

import org.xml.sax.Attributes;
import com.openexchange.office.filter.odf.ElementNSWriter;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.UnknownContentHandler;

public class AnnotationHandler extends SaxContextHandler {

	final private Annotation annotation;

	public AnnotationHandler(SaxContextHandler parentContext, Annotation annotation) {
    	super(parentContext);

    	this.annotation = annotation;
	}

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
    	if(qName.equals("dc:creator")) {
    		return this;
    	}
    	else if(qName.equals("loext:sender-initials")) {
    	    return this;
    	}
    	else if(qName.equals("dc:date")) {
    		return this;
    	}
    	final SaxContextHandler textHandler = TextContentHelper.startElement(this, annotation, attributes, uri, localName, qName);
    	if(textHandler!=null) {
    		return textHandler;
    	}
		final ElementNSWriter element = new ElementNSWriter(getFileDom(), attributes, uri, qName);
		annotation.getContent().add(element);
		return new UnknownContentHandler(this, element);
    }

	@Override
	public void endContext(String qName, String characters) {
		super.endContext(qName, characters);

		if(qName.equals("dc:creator")) {
			annotation.setCreator(characters);
		}
        else if(qName.equals("loext:sender-initials")) {
            annotation.setInitials(characters);
        }
		else if(qName.equals("dc:date")) {
			annotation.setDate(characters);
		}
	}
}
