/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.draw;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;

public class Polygon extends Shape {

    public Polygon(AttributesImpl attributes, String uri, String localName, String qName, GroupShape parentGroup, boolean rootShape, boolean contentStyle) {
        super(attributes, uri, localName, qName, parentGroup, rootShape, contentStyle);
    }

    @Override
    public void createAttrs(OdfOperationDoc operationDocument, OpAttrs attrs, boolean contentAutoStyle) {
        super.createAttrs(operationDocument, attrs, contentAutoStyle);

        final OpAttrs geometryAttrs = attrs.getMap(OCKey.GEOMETRY.value(), true);
        final List<OpAttrs> pathList = new ArrayList<OpAttrs>(1);
        geometryAttrs.put(OCKey.PATH_LIST.value(), pathList);

        final String drawPoints = attributes.getValue("draw:points");
        final String[] tokens = StringUtils.split(drawPoints);
        if(tokens!=null&&tokens.length>0) {
            final ViewBox viewBox = new ViewBox(attributes.getValue("svg:viewBox"));
            if(viewBox.isValid()) {
                final OpAttrs path = new OpAttrs();
                path.put(OCKey.WIDTH.value(), viewBox.getWidth());
                path.put(OCKey.HEIGHT.value(), viewBox.getHeight());
                if("polyline".equals(localName)) {
                    path.put(OCKey.FILL_MODE.value(), "none");
                }
                pathList.add(path);

                final boolean closed = "draw:polygon".equals(qName);
                int tokenCount = tokens.length;
                if(closed) {
                    tokenCount++;
                }
                final List<OpAttrs> commands = new ArrayList<OpAttrs>(tokenCount);
                path.put(OCKey.COMMANDS.value(), commands);
                String c = "moveTo";
                for(String token:tokens) {
                    final OpAttrs geometryCommand = new OpAttrs();
                    final String[] points = StringUtils.split(token, ',');
                    if(points!=null&&points.length==2) {
                        int x = 0;
                        int y = 0;
                        try {
                            x = Integer.parseInt(points[0]) - viewBox.getX();
                            y = Integer.parseInt(points[1]) - viewBox.getY();
                        }
                        catch(NumberFormatException e) {
                            // ohoh
                        }
                        geometryCommand.put(OCKey.X.value(), x);
                        geometryCommand.put(OCKey.Y.value(), y);
                        geometryCommand.put(OCKey.C.value(), c);
                    }
                    commands.add(geometryCommand);
                    c = "lineTo";
                }
                if(closed) {
                    final OpAttrs geometryCommand = new OpAttrs();
                    geometryCommand.put(OCKey.C.value(), "close");
                    commands.add(geometryCommand);
                }
            }
        }
    }
}
